/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.conversation;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.axis.encoding.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.conversation.message.token.DerivedKeyToken;
import org.apache.ws.security.conversation.message.token.SecurityContextToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConversationUtil {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$conversation$ConversationUtil == null ? (class$org$apache$ws$security$conversation$ConversationUtil = ConversationUtil.class$("org.apache.ws.security.conversation.ConversationUtil")) : class$org$apache$ws$security$conversation$ConversationUtil).getName());
    private static final String ID_SEPARATER = "$$$$";
    static /* synthetic */ Class class$org$apache$ws$security$conversation$ConversationUtil;

    public static String generateNonce(int length) {
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] nonceValue = new byte[length / 8];
        random.nextBytes(nonceValue);
        return Base64.encode((byte[])nonceValue);
    }

    public static String getDerivedKeyTokenId(String identifier) {
        return ConversationUtil.getUuidAndDerivedKeyTokenId(identifier)[1];
    }

    public static String getUuid(String identifier) {
        return ConversationUtil.getUuidAndDerivedKeyTokenId(identifier)[0];
    }

    public static String[] getUuidAndDerivedKeyTokenId(String identifier) {
        String[] returnValue = new String[2];
        int uuidEnd = identifier.indexOf(ID_SEPARATER);
        returnValue[0] = identifier.substring(0, uuidEnd);
        returnValue[1] = identifier.substring(uuidEnd + ID_SEPARATER.length(), identifier.length());
        return returnValue;
    }

    public static String generateIdentifier(String uuid, String derivedKeyTokenId) {
        log.debug((Object)("ConversationUtil: Generating identifier. session id: " + uuid + ", dkt id: " + derivedKeyTokenId));
        return uuid + ID_SEPARATER + derivedKeyTokenId;
    }

    public static String generateUuid() {
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] nonceValue = new byte[32];
        random.nextBytes(nonceValue);
        return Base64.encode((byte[])nonceValue);
    }

    public static String genericID() {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            int i = random.nextInt(Integer.MAX_VALUE);
            return String.valueOf(i);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SecurityContextToken getSCT(DerivedKeyToken dkToken) throws ConversationException {
        Object uuid = null;
        Document doc = dkToken.getElement().getOwnerDocument();
        NodeList ndList = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/ws/2004/04/sc", "SecurityContextToken");
        if (ndList.getLength() == 0) {
            throw new ConversationException("Cannot find SCT");
        }
        try {
            Element ele = (Element)ndList.item(0);
            SecurityContextToken sct = new SecurityContextToken(ele);
            return sct;
        }
        catch (WSSecurityException e) {
            throw new ConversationException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

