/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.axis.security.trust.secconv.interop;

import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.types.URI;
import org.apache.axis.utils.DOM2Writer;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.conversation.message.token.RequestSecurityTokenResponse;
import org.apache.ws.security.conversation.message.token.RequestedProofToken;
import org.apache.ws.security.conversation.message.token.RequestedSecurityToken;
import org.apache.ws.security.conversation.message.token.SecurityContextToken;
import org.apache.ws.security.policy.message.token.AppliesTo;
import org.apache.ws.security.trust.message.token.BinarySecret;
import org.apache.ws.security.trust.message.token.LifeTime;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SAML2SCTIssuer {
    private String uuidOfSCT = null;
    private byte[] sharedKey = null;
    private String samlUUID = null;

    public Document issue(Document req, Document res) throws Exception {
        Element samEle = (Element)WSSecurityUtil.findElement(req, "Assertion", "urn:oasis:names:tc:SAML:1.0:assertion");
        this.samlUUID = samEle.getAttribute("AssertionID");
        Element elemAppliesTo = (Element)WSSecurityUtil.findElement(req, AppliesTo.TOKEN.getLocalPart(), AppliesTo.TOKEN.getNamespaceURI());
        Node elemEpr = null;
        NodeList list = elemAppliesTo.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() != 1) continue;
            elemEpr = (Element)list.item(i);
            break;
        }
        Node AddressElement = null;
        NodeList listAdd = elemEpr.getChildNodes();
        for (int i = 0; i < listAdd.getLength(); ++i) {
            if (listAdd.item(i).getNodeType() != 1) continue;
            AddressElement = (Element)listAdd.item(i);
            break;
        }
        System.out.println(DOM2Writer.nodeToString(AddressElement, (boolean)true));
        System.out.println(((Text)AddressElement.getFirstChild()).getNodeValue());
        AppliesTo appliesToRes = new AppliesTo(res);
        String addValue = ((Text)AddressElement.getFirstChild()).getNodeValue();
        EndpointReference eprNew = new EndpointReference((URI)new AttributedURI(addValue));
        appliesToRes.setAnyElement(eprNew.toDOM(res));
        LifeTime lt = new LifeTime(res, 720);
        RequestedSecurityToken reqtedSecTok = new RequestedSecurityToken(res);
        SecurityContextToken sct = new SecurityContextToken(res);
        this.uuidOfSCT = sct.getIdentifier();
        LifeTime lt2 = new LifeTime(res, 720);
        sct.setElement(lt2.getElement());
        reqtedSecTok.addToken(sct.getElement());
        RequestedProofToken reqProofTok = new RequestedProofToken(res);
        BinarySecret binSecret = new BinarySecret(res);
        binSecret.setTypeAttribute("http://schemas.xmlsoap.org/ws/2004/04/security/trust/SymmetricKey");
        binSecret.setBinarySecretValue("0987654321123456");
        this.sharedKey = "0987654321123456".getBytes();
        reqProofTok.addToken(binSecret.getElement());
        RequestSecurityTokenResponse rSTR = new RequestSecurityTokenResponse(res);
        rSTR.addToken(lt.getElement());
        rSTR.addToken(appliesToRes.getElement());
        rSTR.addToken(reqtedSecTok.getElement());
        rSTR.addToken(reqProofTok.getElement());
        Element elemEnv = res.getDocumentElement();
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(elemEnv);
        Element elemBody = WSSecurityUtil.findBodyElement(elemEnv.getOwnerDocument(), soapConstants);
        elemBody.appendChild(rSTR.getElement());
        return res;
    }

    public byte[] getSharedKey() {
        return this.sharedKey;
    }

    public String getUuidOfSCT() {
        return this.uuidOfSCT;
    }

    public void setSharedKey(byte[] bs) {
        this.sharedKey = bs;
    }

    public void setUuidOfSCT(String string) {
        this.uuidOfSCT = string;
    }

    public String getSamlUUID() {
        return this.samlUUID;
    }
}

