/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.axis.security.conversation;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.conversation.ConvEngineResult;
import org.apache.ws.security.conversation.ConversationEngine;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.conversation.ConversationManager;
import org.apache.ws.security.conversation.ConversationSession;
import org.apache.ws.security.conversation.ConversationUtil;
import org.apache.ws.security.conversation.DerivedKeyCallbackHandler;
import org.apache.ws.security.conversation.message.info.DerivedKeyInfo;
import org.apache.ws.security.conversation.message.token.SecurityContextToken;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.StringUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.Init;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConversationServerHandler
extends BasicHandler {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$axis$security$conversation$ConversationServerHandler == null ? (class$org$apache$ws$axis$security$conversation$ConversationServerHandler = ConversationServerHandler.class$("org.apache.ws.axis.security.conversation.ConversationServerHandler")) : class$org$apache$ws$axis$security$conversation$ConversationServerHandler).getName());
    private boolean doDebug = false;
    private static DerivedKeyCallbackHandler dkcbHandler = new DerivedKeyCallbackHandler();
    private static boolean isConfigured = false;
    private SOAPConstants soapConstants = null;
    private HashMap configurator = new HashMap();
    private int[] actionsInt = null;
    private boolean isSessionInfoConfigured = false;
    private boolean isInitTrustVerified = false;
    private Vector sigParts = null;
    private Vector encParts = null;
    private int keyLen = -1;
    static /* synthetic */ Class class$org$apache$ws$axis$security$conversation$ConversationServerHandler;

    public ConversationServerHandler() {
        log.debug((Object)"ConversationServerHandler :: created");
    }

    public void invoke(MessageContext msg) throws AxisFault {
        log.debug((Object)"ConversationServerHandler :: invoked");
        if (msg.getPastPivot()) {
            this.doResponse(msg);
        } else {
            this.doRequest(msg);
        }
    }

    private void doRequest(MessageContext msg) throws AxisFault {
        if (!this.isSessionInfoConfigured) {
            this.initSessionInfo();
            this.isSessionInfoConfigured = true;
        }
        Document doc = null;
        Message message = msg.getCurrentMessage();
        SOAPPart sPart = (SOAPPart)message.getSOAPPart();
        try {
            doc = ((SOAPEnvelope)sPart.getEnvelope()).getAsDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.soapConstants = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
        ConversationEngine eng = new ConversationEngine(this.configurator);
        try {
            Vector results = eng.processSecConvHeader(doc, "", dkcbHandler, (String)this.configurator.get("passwordCallbackClass"));
            ConvEngineResult convResult = null;
            String uuid = "";
            Stack<Integer> stk = new Stack<Integer>();
            for (int i = 0; i < this.actionsInt.length; ++i) {
                stk.push(new Integer(this.actionsInt[i]));
            }
            int act = -1;
            boolean rstr = false;
            block13: for (int i = 0; i < results.size(); ++i) {
                convResult = (ConvEngineResult)results.get(i);
                switch (convResult.getAction()) {
                    case 1: {
                        log.debug((Object)"ConversationServerHandler :: Found RSTR result");
                        uuid = convResult.getUuid();
                        rstr = true;
                        continue block13;
                    }
                    case 3: {
                        log.debug((Object)"ConversationServerHandler :: Found dk_encrypt result");
                        continue block13;
                    }
                    case 2: {
                        log.debug((Object)"ConversationServerHandler :: Found dk_sign result");
                        continue block13;
                    }
                    case 5: {
                        log.debug((Object)"ConversationServerHandler :: Found SCT result");
                        uuid = convResult.getUuid();
                    }
                }
            }
            if (!uuid.equals("") && uuid != null) {
                msg.setProperty("SCT_Identifier", (Object)uuid);
            }
        }
        catch (ConversationException e1) {
            e1.printStackTrace();
            throw new AxisFault("CovnersationServerHandler :: " + e1.getMessage());
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XMLUtils.outputDOM((Node)doc, (OutputStream)os, (boolean)true);
        String osStr = os.toString();
        sPart.setCurrentMessage((Object)osStr, 1);
        SOAPHeader sHeader = null;
        try {
            sHeader = message.getSOAPEnvelope().getHeader();
        }
        catch (Exception ex) {
            throw new AxisFault("ConversatonServerHandler: cannot get SOAP header after security processing", (Throwable)ex);
        }
        String actor = null;
        Iterator headers = sHeader.examineHeaderElements(actor);
        SOAPHeaderElement headerElement = null;
        while (headers.hasNext()) {
            SOAPHeaderElement hE = (SOAPHeaderElement)headers.next();
            if (!hE.getLocalName().equals("Security") || !hE.getNamespaceURI().equals(WSConstants.WSSE_NS)) continue;
            headerElement = hE;
            break;
        }
        ((org.apache.axis.message.SOAPHeaderElement)headerElement).setProcessed(true);
        msg.setProperty("DkcbHandler", (Object)dkcbHandler);
    }

    private void doResponse(MessageContext msg) throws AxisFault {
        if (!this.isSessionInfoConfigured) {
            this.initSessionInfo();
            this.isSessionInfoConfigured = true;
        }
        Document doc = null;
        Message message = msg.getCurrentMessage();
        SOAPPart sPart = (SOAPPart)message.getSOAPPart();
        try {
            doc = (Document)msg.getProperty("SND_SECURTIY");
            if (doc == null) {
                doc = ((SOAPEnvelope)sPart.getEnvelope()).getAsDocument();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AxisFault("CovnersationServerHandler :: " + e.getMessage());
        }
        String uuid = (String)msg.getProperty("SCT_Identifier");
        if (uuid == null) {
            System.out.println("UUID NULl line :: 346");
        }
        try {
            ConversationSession session = DerivedKeyCallbackHandler.getSession(uuid);
            if (session.isAddBase2Message()) {
                Element securityHeader = WSSecurityUtil.findWsseSecurityHeaderBlock(WSSConfig.getDefaultWSConfig(), doc, doc.getDocumentElement(), true);
                WSSecurityUtil.appendChildElement(doc, securityHeader, new SecurityContextToken(doc, uuid).getElement());
            }
            ConversationManager manager = new ConversationManager();
            for (int i = 0; i < this.actionsInt.length; ++i) {
                SecurityTokenReference stRef2Base = null;
                if (session.getRef2Base() != null) {
                    stRef2Base = new SecurityTokenReference(WSSConfig.getDefaultWSConfig(), doc);
                    Reference ref = new Reference(WSSConfig.getDefaultWSConfig(), doc);
                    Reference oldRef = session.getRef2Base();
                    ref.setURI(oldRef.getURI());
                    ref.setValueType(oldRef.getValueType());
                    stRef2Base.setReference(ref);
                }
                DerivedKeyInfo dkInfo = manager.createDerivedKeyToken(doc, uuid, dkcbHandler, stRef2Base, this.keyLen);
                String genID = dkInfo.getId();
                SecurityTokenReference stRef = dkInfo.getSecTokRef2DkToken();
                if (this.actionsInt[i] == 2) {
                    manager.performDK_ENCR(ConversationUtil.generateIdentifier(uuid, genID), "", true, doc, stRef, dkcbHandler, this.encParts, (String)this.configurator.get("dkEncryptionAlgorithm"));
                } else if (this.actionsInt[i] == 1) {
                    manager.performDK_Sign(doc, dkcbHandler, uuid, dkInfo, this.sigParts);
                }
                manager.addDkToken(doc, dkInfo);
            }
        }
        catch (ConversationException e1) {
            e1.printStackTrace();
            throw new AxisFault("ConversationClientHandler ::" + e1.getMessage());
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XMLUtils.outputDOM((Node)doc, (OutputStream)os, (boolean)true);
        String osStr = os.toString();
        sPart.setCurrentMessage((Object)osStr, 1);
    }

    private void initSessionInfo() throws AxisFault {
        this.configurator = new HashMap();
        String tmpStr = (String)this.getOption("keyFrequency");
        if (tmpStr != null) {
            log.debug((Object)("Key Frequency is set ::" + tmpStr));
            this.configurator.put("keyFrequency", new Integer(tmpStr));
        }
        if ((tmpStr = (String)this.getOption("derivedKeyAction")) != null) {
            log.debug((Object)("Derived Key Action is read ::" + tmpStr));
            String[] action = StringUtil.split(tmpStr, ' ');
            this.actionsInt = new int[action.length];
            for (int i = 0; i < action.length; ++i) {
                if (action[i].equalsIgnoreCase("Signature")) {
                    this.actionsInt[i] = 1;
                    continue;
                }
                if (!action[i].equalsIgnoreCase("Encrypt")) continue;
                this.actionsInt[i] = 2;
            }
        }
        if ((tmpStr = (String)this.getOption("serverPropFile")) != null) {
            this.configurator.put("serverPropFile", tmpStr);
        }
        if ((tmpStr = (String)this.getOption("keyLegnth")) != null) {
            log.debug((Object)("Key Frequency is set ::" + tmpStr));
            this.keyLen = Integer.parseInt(tmpStr);
            this.configurator.put("keyLegnth", new Long(tmpStr));
        }
        if ((tmpStr = (String)this.getOption("passwordCallbackClass")) != null) {
            this.configurator.put("passwordCallbackClass", tmpStr);
        } else {
            log.debug((Object)"Set the pass word call back class.");
        }
        tmpStr = (String)this.getOption("signatureParts");
        if (tmpStr != null) {
            this.sigParts = new Vector();
            this.splitEncParts(tmpStr, this.sigParts);
        }
        if ((tmpStr = (String)this.getOption("encryptionParts")) != null) {
            this.encParts = new Vector();
            this.splitEncParts(tmpStr, this.encParts);
        }
        if ((tmpStr = (String)this.getOption("decryptionPropFile")) != null) {
            this.configurator.put("decryptionPropFile", tmpStr);
            System.out.println("Decryption properties read");
        }
        if ((tmpStr = (String)this.getOption("dkEncryptionAlgorithm")) != null) {
            this.configurator.put("dkEncryptionAlgorithm", tmpStr);
        }
    }

    private void splitEncParts(String tmpS, Vector encryptParts) throws AxisFault {
        WSEncryptionPart encPart = null;
        String[] rawParts = StringUtil.split(tmpS, ';');
        for (int i = 0; i < rawParts.length; ++i) {
            String[] partDef = StringUtil.split(rawParts[i], '}');
            if (partDef.length == 1) {
                if (this.doDebug) {
                    log.debug((Object)("single partDef: '" + partDef[0] + "'"));
                }
                encPart = new WSEncryptionPart(partDef[0].trim(), this.soapConstants.getEnvelopeURI(), "Content");
            } else if (partDef.length == 3) {
                String mode = partDef[0].trim();
                mode = mode.length() <= 1 ? "Content" : mode.substring(1);
                String nmSpace = partDef[1].trim();
                nmSpace = nmSpace.length() <= 1 ? this.soapConstants.getEnvelopeURI() : nmSpace.substring(1);
                String element = partDef[2].trim();
                if (this.doDebug) {
                    log.debug((Object)("partDefs: '" + mode + "' ,'" + nmSpace + "' ,'" + element + "'"));
                }
                encPart = new WSEncryptionPart(element, nmSpace, mode);
            } else {
                throw new AxisFault("WSDoAllSender: wrong part definition: " + tmpS);
            }
            encryptParts.add(encPart);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Init.init();
    }
}

