/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.xmldb.commands;

import org.w3c.dom.Element;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import uk.org.ogsadai.activity.xmldb.commands.Command;
import uk.org.ogsadai.activity.xmldb.commands.CommandContext;
import uk.org.ogsadai.activity.xmldb.commands.XMLDBCommandExecutionException;
import uk.org.ogsadai.activity.xmldb.commands.XMLDBCommandSpecificationException;
import uk.org.ogsadai.activity.xmldb.commands.XMLDBRemoveResourceException;
import uk.org.ogsadai.activity.xmldb.commands.XMLDBStreamNotFoundException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLMissingAttributeException;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class RemoveResourceCommand
implements Command {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)RemoveResourceCommand.class);
    private String mCommandName;
    private String mName;

    public void initialise(String commandName, Element element) throws XMLDBCommandSpecificationException, XMLDBCommandExecutionException {
        this.mCommandName = commandName;
        try {
            this.mName = XMLUtilities.parseAttribute((Element)element, (String)"name", (boolean)true);
        }
        catch (XMLMissingAttributeException e) {
            throw new XMLDBCommandSpecificationException(this.mCommandName, e);
        }
        catch (XMLParseException e) {
            throw new XMLDBCommandExecutionException(this.mCommandName, e);
        }
    }

    public void execute(CommandContext context) throws XMLDBCommandSpecificationException, XMLDBCommandExecutionException {
        String parentName = null;
        try {
            Collection collection = context.getCollection();
            parentName = collection.getName();
            Resource resource = collection.getResource(this.mName);
            collection.removeResource(resource);
            context.getOutput().put((Object)this.generateXML());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removed resource " + this.mName + " from collection " + parentName);
            }
        }
        catch (XMLDBException e) {
            throw new XMLDBCommandExecutionException(this.mCommandName, (Throwable)((Object)new XMLDBRemoveResourceException(parentName, this.mName, e)));
        }
        catch (XMLDBStreamNotFoundException e) {
            throw new XMLDBCommandSpecificationException(this.mCommandName, (Throwable)((Object)e));
        }
    }

    private String generateXML() {
        StringBuffer s = new StringBuffer();
        s.append('<');
        s.append("removedResource");
        s.append(" ");
        s.append("name");
        s.append("=\"");
        s.append(this.mName);
        s.append("\"/>\n");
        return s.toString();
    }
}

