/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.xmldb.commands;

import java.util.Properties;
import org.w3c.dom.Element;
import uk.org.ogsadai.activity.xmldb.commands.Command;
import uk.org.ogsadai.activity.xmldb.commands.CommandFactory;
import uk.org.ogsadai.activity.xmldb.commands.XMLDBCommandCreationException;
import uk.org.ogsadai.activity.xmldb.commands.XMLDBCommandExecutionException;
import uk.org.ogsadai.activity.xmldb.commands.XMLDBCommandSpecificationException;
import uk.org.ogsadai.activity.xmldb.commands.XMLDBUnsupportedCommandException;
import uk.org.ogsadai.exception.DAIClassCreateException;
import uk.org.ogsadai.exception.DAIClassMissingInterfaceException;
import uk.org.ogsadai.exception.DAIClassNotFoundException;

public class PropertiesCommandFactory
implements CommandFactory {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private Properties mCommands;

    public PropertiesCommandFactory(Properties properties) {
        this.mCommands = properties;
    }

    public Command createCommand(Element element) throws XMLDBCommandCreationException, XMLDBUnsupportedCommandException, XMLDBCommandSpecificationException, XMLDBCommandExecutionException {
        Command command = null;
        String elementName = element.getLocalName();
        String className = this.mCommands.getProperty(elementName);
        if (className != null && className.length() > 0) {
            try {
                Class<?> commandClass = Class.forName(className);
                Object object = commandClass.newInstance();
                if (!(object instanceof Command)) {
                    throw new XMLDBCommandCreationException(elementName, (Throwable)new DAIClassMissingInterfaceException(object.getClass().toString(), "uk.org.ogsadai.activity.xmldb.commands.Command"));
                }
                command = (Command)object;
                command.initialise(elementName, element);
            }
            catch (ClassNotFoundException e) {
                throw new XMLDBCommandCreationException(elementName, (Throwable)new DAIClassNotFoundException(className));
            }
            catch (InstantiationException e) {
                throw new XMLDBCommandCreationException(elementName, (Throwable)new DAIClassCreateException(className, (Throwable)e));
            }
            catch (IllegalAccessException e) {
                throw new XMLDBCommandCreationException(elementName, (Throwable)new DAIClassCreateException(className, (Throwable)e));
            }
        } else {
            throw new XMLDBUnsupportedCommandException(elementName);
        }
        return command;
    }
}

