/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.xmldb.commands;

import org.w3c.dom.Element;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import uk.org.ogsadai.activity.xmldb.commands.Command;
import uk.org.ogsadai.activity.xmldb.commands.CommandContext;
import uk.org.ogsadai.activity.xmldb.commands.XMLDBCommandExecutionException;
import uk.org.ogsadai.activity.xmldb.commands.XMLDBCommandSpecificationException;
import uk.org.ogsadai.activity.xmldb.commands.XMLDBListCollectionsException;
import uk.org.ogsadai.activity.xmldb.commands.XMLDBStreamNotFoundException;
import uk.org.ogsadai.common.msgs.DAILogger;

public class ListCollectionsCommand
implements Command {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)ListCollectionsCommand.class);
    private String mCommandName;

    public void initialise(String commandName, Element element) throws XMLDBCommandSpecificationException, XMLDBCommandExecutionException {
        this.mCommandName = commandName;
    }

    public void execute(CommandContext context) throws XMLDBCommandSpecificationException, XMLDBCommandExecutionException {
        String parentName = null;
        try {
            Collection collection = context.getCollection();
            parentName = collection.getName();
            int count = collection.getChildCollectionCount();
            String[] names = collection.listChildCollections();
            context.getOutput().put((Object)this.composeXML(count, names));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Listed child collections of collection " + parentName);
            }
        }
        catch (XMLDBException e) {
            throw new XMLDBCommandExecutionException(this.mCommandName, (Throwable)((Object)new XMLDBListCollectionsException(parentName, e)));
        }
        catch (XMLDBStreamNotFoundException e) {
            throw new XMLDBCommandSpecificationException(this.mCommandName, (Throwable)((Object)e));
        }
    }

    private final String composeXML(int count, String[] names) {
        StringBuffer s = new StringBuffer();
        s.append("<");
        s.append("collectionNames");
        s.append(" ");
        s.append("count");
        s.append("=\"");
        s.append(count);
        s.append("\">\n");
        int numNames = names.length;
        for (int i = 0; i < numNames; ++i) {
            s.append("  <");
            s.append("name");
            s.append(">");
            s.append(names[i]);
            s.append("</");
            s.append("name");
            s.append(">\n");
        }
        s.append("</");
        s.append("collectionNames");
        s.append(">\n");
        return s.toString();
    }
}

