/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.xmldb.commands;

import java.io.InputStream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;
import uk.org.ogsadai.activity.xmldb.commands.Command;
import uk.org.ogsadai.activity.xmldb.commands.CommandContext;
import uk.org.ogsadai.activity.xmldb.commands.XMLDBCommandExecutionException;
import uk.org.ogsadai.activity.xmldb.commands.XMLDBCommandSpecificationException;
import uk.org.ogsadai.activity.xmldb.commands.XMLDBCreateResourceException;
import uk.org.ogsadai.activity.xmldb.commands.XMLDBStreamNotFoundException;
import uk.org.ogsadai.common.BlockReaderInputStream;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLDocumentException;
import uk.org.ogsadai.common.xml.XMLMissingAttributeException;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class CreateResourceCommand
implements Command {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)CreateResourceCommand.class);
    private String mCommandName;
    private String mName;
    private boolean mEmbedded;
    private String mInputName;
    private Node mResource;

    public void initialise(String commandName, Element element) throws XMLDBCommandSpecificationException, XMLDBCommandExecutionException {
        this.mCommandName = commandName;
        try {
            this.mName = XMLUtilities.parseAttribute((Element)element, (String)"name", (boolean)false);
            this.mInputName = XMLUtilities.parseAttribute((Element)element, (String)"from", (boolean)false);
            if (this.mInputName == null || this.mInputName.length() == 0) {
                this.mEmbedded = true;
                this.mResource = (Element)XMLUtilities.getChildElements((Element)element).get(0);
            } else {
                this.mEmbedded = false;
            }
        }
        catch (XMLMissingAttributeException e) {
            throw new XMLDBCommandSpecificationException(this.mCommandName, e);
        }
        catch (XMLParseException e) {
            throw new XMLDBCommandExecutionException(this.mCommandName, e);
        }
    }

    public String getInputName() {
        if (!this.mEmbedded) {
            return this.mInputName;
        }
        return null;
    }

    public void execute(CommandContext context) throws XMLDBCommandSpecificationException, XMLDBCommandExecutionException {
        String parentName = null;
        try {
            Collection collection = context.getCollection();
            parentName = collection.getName();
            if (this.mName == null || this.mName.length() == 0) {
                this.mName = collection.createId();
            }
            if (!this.mEmbedded) {
                this.mResource = XMLUtilities.xmlStreamToDOM((InputStream)new BlockReaderInputStream(context.getInput(this.mInputName)), (boolean)false);
            }
            XMLResource xmlResource = (XMLResource)collection.createResource(this.mName, "XMLResource");
            xmlResource.setContentAsDOM(this.mResource);
            collection.storeResource((Resource)xmlResource);
            context.getOutput().put((Object)this.generateXML());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created resource " + this.mName + " in collection " + parentName);
            }
        }
        catch (XMLDBException e) {
            throw new XMLDBCommandExecutionException(this.mCommandName, (Throwable)((Object)new XMLDBCreateResourceException(parentName, this.mName, e)));
        }
        catch (XMLDBStreamNotFoundException e) {
            throw new XMLDBCommandSpecificationException(this.mCommandName, (Throwable)((Object)e));
        }
        catch (XMLDocumentException e) {
            throw new XMLDBCommandSpecificationException(this.mCommandName, e);
        }
        catch (XMLParseException e) {
            throw new XMLDBCommandExecutionException(this.mCommandName, e);
        }
    }

    private String generateXML() {
        StringBuffer s = new StringBuffer();
        s.append('<');
        s.append("createdResource");
        s.append(" ");
        s.append("name");
        s.append("=\"");
        s.append(this.mName);
        s.append("\"/>\n");
        return s.toString();
    }
}

