/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.xmldb;

import org.w3c.dom.Element;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XUpdateQueryService;
import uk.org.ogsadai.activity.ActivityAuthorizationException;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.xmldb.XMLDBActivity;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLEmptyElementException;
import uk.org.ogsadai.common.xml.XMLMissingAttributeException;
import uk.org.ogsadai.common.xml.XMLMissingElementException;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.dataresource.XMLDBCollectionUseException;
import uk.org.ogsadai.dataresource.XMLDBUnknownSubCollectionException;
import uk.org.ogsadai.exception.AuthorizationExecutionException;
import uk.org.ogsadai.exception.DAIAuthorizationException;
import uk.org.ogsadai.exception.DAIException;

public class XUpdateStatementActivity
extends XMLDBActivity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)XUpdateStatementActivity.class);
    private String mExpression;
    private String mResourceID;

    public XUpdateStatementActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        try {
            this.mExpression = XMLUtilities.parseChildElementValue((Element)element, (String)"http://ogsadai.org.uk/namespaces/2005/10/types", (String)"expression", (boolean)true, (boolean)true);
            this.mResourceID = XMLUtilities.parseChildElementValue((Element)element, (String)"http://ogsadai.org.uk/namespaces/2005/10/types", (String)"resourceId", (boolean)false, (boolean)true);
            this.mInternalOutputs = new String[]{XMLUtilities.parseChildElementAttribute((Element)element, (String)"http://ogsadai.org.uk/namespaces/2005/10/types", (String)"outputStream", (String)"name", (boolean)true, (boolean)true)};
        }
        catch (XMLEmptyElementException e) {
            throw new ActivitySpecificationException(this.getName(), e.getElement());
        }
        catch (XMLMissingElementException e) {
            throw new ActivitySpecificationException(this.getName(), e.getElement());
        }
        catch (XMLMissingAttributeException e) {
            throw new ActivitySpecificationException(this.getName(), e.getElement() + "." + e.getAttribute());
        }
        catch (Exception e) {
            throw new ActivityCreationException(this.getName(), (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("XUpdate - " + this.mExpression);
        }
    }

    public void processBlock() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processBlock: enter");
        }
        try {
            long modifiedNodes = this.update();
            this.mOutput.put((Object)this.resultsToXML(modifiedNodes));
            this.mOutput.close();
            this.setCompleted();
        }
        catch (ActivityExecutionException e) {
            this.setError(e);
        }
        catch (ActivitySpecificationException e) {
            this.setError(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("processBlock: exit");
        }
    }

    private long update() throws ActivityExecutionException, ActivitySpecificationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entering method: perform");
        }
        long modifiedNodes = 0L;
        String collectionName = null;
        try {
            Collection collection = null;
            try {
                collection = this.mDataResource.getXMLDBCollection(this.mSubCollectionName, this.mUserCredentials);
            }
            catch (XMLDBUnknownSubCollectionException e) {
                throw new ActivitySpecificationException(this.getName(), (Throwable)e);
            }
            catch (XMLDBCollectionUseException e) {
                throw new ActivityExecutionException(this.getName(), (Throwable)e);
            }
            catch (DAIAuthorizationException e) {
                throw new ActivitySpecificationException(this.getName(), (Throwable)new ActivityAuthorizationException(this.getName(), (Throwable)e));
            }
            catch (AuthorizationExecutionException e) {
                throw new ActivityExecutionException(this.getName(), (Throwable)e);
            }
            catch (Exception e) {
                throw new ActivityExecutionException(this.getName(), (Throwable)e);
            }
            collectionName = collection.getName();
            XUpdateQueryService mService = (XUpdateQueryService)collection.getService("XUpdateQueryService", "1.0");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Running XUpdate " + this.mExpression + " against " + " resource " + this.mResourceID + " of collection " + collectionName);
            }
            modifiedNodes = this.mResourceID == null ? mService.update(this.mExpression) : mService.updateResource(this.mResourceID, this.mExpression);
            try {
                this.mDataResource.releaseXMLDBCollection(collection);
            }
            catch (DAIException e) {
                throw new ActivityExecutionException(this.getName(), (Throwable)e);
            }
        }
        catch (XMLDBException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exiting method: perform");
        }
        return modifiedNodes;
    }

    private String resultsToXML(long modifiedNodes) {
        StringBuffer results = new StringBuffer();
        results.append('<');
        results.append("modifiedNodes");
        results.append('>');
        results.append(modifiedNodes);
        results.append("</");
        results.append("modifiedNodes");
        results.append('>');
        return results.toString();
    }
}

