/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.xmldb;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XQueryService;
import uk.org.ogsadai.activity.ActivityAuthorizationException;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.xmldb.XMLDBActivity;
import uk.org.ogsadai.client.toolkit.activity.xmldb.XMLResourceSetBlockMaker;
import uk.org.ogsadai.common.BlockMaker;
import uk.org.ogsadai.common.BlockMakerException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLEmptyElementException;
import uk.org.ogsadai.common.xml.XMLMissingAttributeException;
import uk.org.ogsadai.common.xml.XMLMissingElementException;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.dataresource.XMLDBCollectionUseException;
import uk.org.ogsadai.dataresource.XMLDBUnknownSubCollectionException;
import uk.org.ogsadai.exception.AuthorizationExecutionException;
import uk.org.ogsadai.exception.DAIAuthorizationException;

public class XQueryStatementActivity
extends XMLDBActivity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)XQueryStatementActivity.class);
    private BlockMaker mBlocks;
    private String mQuery;
    private Map mNamespaceMappings;
    private String mResourceID;

    public XQueryStatementActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        try {
            this.mQuery = XMLUtilities.parseChildElementValue((Element)element, (String)"http://ogsadai.org.uk/namespaces/2005/10/types", (String)"expression", (boolean)true, (boolean)true);
            this.mResourceID = XMLUtilities.parseChildElementValue((Element)element, (String)"http://ogsadai.org.uk/namespaces/2005/10/types", (String)"resourceId", (boolean)false, (boolean)true);
            NodeList namespaceElements = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "namespace");
            if (namespaceElements.getLength() > 0) {
                this.mNamespaceMappings = new Hashtable();
                for (int i = 0; i < namespaceElements.getLength(); ++i) {
                    Element namespace = (Element)namespaceElements.item(i);
                    String prefix = XMLUtilities.parseAttribute((Element)namespace, (String)"prefix", (boolean)true);
                    String uri = XMLUtilities.parseElementValue((Element)namespace, (boolean)true);
                    this.mNamespaceMappings.put(prefix, uri);
                }
            }
            this.mInternalOutputs = new String[]{XMLUtilities.parseChildElementAttribute((Element)element, (String)"http://ogsadai.org.uk/namespaces/2005/10/types", (String)"resourceSetStream", (String)"name", (boolean)true, (boolean)true)};
        }
        catch (XMLEmptyElementException e) {
            throw new ActivitySpecificationException(this.getName(), e.getElement());
        }
        catch (XMLMissingElementException e) {
            throw new ActivitySpecificationException(this.getName(), e.getElement());
        }
        catch (XMLMissingAttributeException e) {
            throw new ActivitySpecificationException(this.getName(), e.getElement() + "." + e.getAttribute());
        }
        catch (Exception e) {
            throw new ActivityCreationException(this.getName(), (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("XQuery - " + this.mQuery);
        }
    }

    public void processBlock() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processBlock: start");
        }
        try {
            if (this.mBlocks.hasNext()) {
                this.mOutput.put(this.mBlocks.next());
            } else {
                this.setCompleted();
            }
        }
        catch (BlockMakerException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("processBlock: end (status = " + this.getStatus() + ")");
        }
    }

    protected final void processFirst() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processFirst: enter");
        }
        String collectionName = null;
        try {
            Collection collection = null;
            try {
                collection = this.mDataResource.getXMLDBCollection(this.mSubCollectionName, this.mUserCredentials);
            }
            catch (XMLDBUnknownSubCollectionException e) {
                throw new ActivitySpecificationException(this.getName(), (Throwable)e);
            }
            catch (XMLDBCollectionUseException e) {
                throw new ActivityExecutionException(this.getName(), (Throwable)e);
            }
            catch (DAIAuthorizationException e) {
                throw new ActivitySpecificationException(this.getName(), (Throwable)new ActivityAuthorizationException(this.getName(), (Throwable)e));
            }
            catch (AuthorizationExecutionException e) {
                throw new ActivityExecutionException(this.getName(), (Throwable)e);
            }
            catch (Exception e) {
                throw new ActivityExecutionException(this.getName(), (Throwable)e);
            }
            collectionName = collection.getName();
            XQueryService mService = (XQueryService)collection.getService("XQueryService", "1.0");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting the namespace mappings.");
            }
            if (this.mNamespaceMappings != null) {
                Iterator i = this.mNamespaceMappings.keySet().iterator();
                while (i.hasNext()) {
                    String prefix = (String)i.next();
                    String uri = (String)this.mNamespaceMappings.get(prefix);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Setting the namespace mapping: " + prefix + " = " + uri);
                    }
                    mService.setNamespace(prefix, uri);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Running XPath query " + this.mQuery + " against " + " resource " + this.mResourceID + " of collection " + collectionName);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Running XQuery query " + this.mQuery + " against " + " resource " + this.mResourceID + " of collection " + collectionName);
            }
            ResourceSet results = this.mResourceID == null ? mService.query(this.mQuery) : mService.queryResource(this.mResourceID, this.mQuery);
            try {
                this.mBlocks = new XMLResourceSetBlockMaker(results);
            }
            catch (BlockMakerException e) {
                throw new ActivityExecutionException(this.getName(), (Throwable)e);
            }
            try {
                this.mDataResource.releaseXMLDBCollection(collection);
            }
            catch (XMLDBCollectionUseException e) {
                throw new ActivityExecutionException(this.getName(), (Throwable)e);
            }
        }
        catch (ActivitySpecificationException e) {
            this.setError(e);
        }
        catch (ActivityExecutionException e) {
            this.setError(e);
        }
        catch (XMLDBException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("processFirst: exit");
        }
    }
}

