/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.xmldb;

import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XMLResource;
import uk.org.ogsadai.common.files.DAIFileNotFileException;
import uk.org.ogsadai.common.files.DAIFileNotFoundException;
import uk.org.ogsadai.common.files.DAIFileReadIOException;
import uk.org.ogsadai.common.files.FileUtilities;
import uk.org.ogsadai.common.xml.XMLDocumentException;
import uk.org.ogsadai.common.xml.XMLFileException;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class XMLDBUtilities {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";

    public static Collection createCollection(Collection parent, String name) throws XMLDBException {
        CollectionManagementService service = (CollectionManagementService)parent.getService("CollectionManagementService", "1.0");
        Collection collection = parent.getChildCollection(name);
        if (collection != null) {
            service.removeCollection(name);
        }
        collection = service.createCollection(name);
        return collection;
    }

    public static void addResource(Collection collection, String resourceName, String resourcePath) throws XMLDBException, XMLFileException, XMLDocumentException, XMLParseException {
        XMLResource resource = (XMLResource)collection.createResource(resourceName, "XMLResource");
        Document resourceDoc = XMLUtilities.xmlFileToDOM((String)resourcePath, (boolean)false);
        resource.setContentAsDOM((Node)resourceDoc);
        collection.storeResource((Resource)resource);
    }

    public static void removeCollection(Collection parent, String name) throws XMLDBException {
        if (parent.getChildCollection(name) != null) {
            CollectionManagementService service = (CollectionManagementService)parent.getService("CollectionManagementService", "1.0");
            service.removeCollection(name);
        }
    }

    public static void createCollection(String url) throws XMLDBException {
        int i = url.lastIndexOf("/");
        String base = url.substring(0, i);
        String name = url.substring(i + 1);
        Collection collection = DatabaseManager.getCollection((String)base);
        CollectionManagementService service = (CollectionManagementService)collection.getService("CollectionManagementService", "1.0");
        service.createCollection(name).close();
        collection.close();
    }

    public static void addResource(String url, File file) throws XMLDBException, DAIFileNotFoundException, DAIFileNotFileException, DAIFileReadIOException {
        String name = file.getName().substring(0, file.getName().lastIndexOf("."));
        String content = FileUtilities.readStringFromFile((String)file.getAbsolutePath());
        Collection collection = DatabaseManager.getCollection((String)url);
        XMLResource resource = (XMLResource)collection.createResource(name, "XMLResource");
        resource.setContent((Object)content);
        collection.storeResource((Resource)resource);
        collection.close();
    }

    public static void removeCollection(String url) throws XMLDBException {
        int i = url.lastIndexOf("/");
        String base = url.substring(0, i);
        String name = url.substring(i + 1);
        Collection collection = DatabaseManager.getCollection((String)base);
        CollectionManagementService service = (CollectionManagementService)collection.getService("CollectionManagementService", "1.0");
        service.removeCollection(name);
        collection.close();
    }
}

