/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.xmldb;

import java.util.List;
import org.w3c.dom.Element;
import org.xmldb.api.base.Collection;
import uk.org.ogsadai.activity.ActivityAuthorizationException;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.xmldb.XMLDBActivity;
import uk.org.ogsadai.activity.xmldb.commands.Command;
import uk.org.ogsadai.activity.xmldb.commands.CommandContextImpl;
import uk.org.ogsadai.activity.xmldb.commands.CommandFactory;
import uk.org.ogsadai.activity.xmldb.commands.CreateResourceCommand;
import uk.org.ogsadai.activity.xmldb.commands.XMLDBCommandCreationException;
import uk.org.ogsadai.activity.xmldb.commands.XMLDBCommandExecutionException;
import uk.org.ogsadai.activity.xmldb.commands.XMLDBCommandSpecificationException;
import uk.org.ogsadai.activity.xmldb.commands.XMLDBUnsupportedCommandException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLEmptyElementException;
import uk.org.ogsadai.common.xml.XMLMissingAttributeException;
import uk.org.ogsadai.common.xml.XMLMissingElementException;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.dataresource.XMLDBCollectionUseException;
import uk.org.ogsadai.dataresource.XMLDBUnknownSubCollectionException;
import uk.org.ogsadai.exception.AuthorizationExecutionException;
import uk.org.ogsadai.exception.DAIAuthorizationException;

public abstract class XMLDBCommandActivity
extends XMLDBActivity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)XMLDBCommandActivity.class);
    private final Command mCommand;

    public XMLDBCommandActivity(Element element, CommandFactory factory) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        List childElements = XMLUtilities.getChildElements((Element)element);
        int commandElementIndex = childElements.size() == 3 ? 1 : 0;
        Element commandElement = (Element)childElements.get(commandElementIndex);
        try {
            this.mCommand = factory.createCommand(commandElement);
            String inputName = null;
            if (this.mCommand instanceof CreateResourceCommand) {
                inputName = ((CreateResourceCommand)this.mCommand).getInputName();
            }
            if (inputName != null) {
                this.mInternalInputs = new String[]{inputName};
            }
        }
        catch (XMLDBCommandCreationException e) {
            throw new ActivityCreationException(this.getName(), (Throwable)((Object)e));
        }
        catch (XMLDBUnsupportedCommandException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)((Object)e));
        }
        catch (XMLDBCommandSpecificationException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)((Object)e));
        }
        catch (XMLDBCommandExecutionException e) {
            throw new ActivityCreationException(this.getName(), (Throwable)((Object)e));
        }
        try {
            this.mInternalOutputs = new String[]{XMLUtilities.parseChildElementAttribute((Element)element, (String)"http://ogsadai.org.uk/namespaces/2005/10/types", (String)"outputStream", (String)"name", (boolean)true, (boolean)true)};
        }
        catch (XMLEmptyElementException e) {
            throw new ActivitySpecificationException(this.getName(), e.getElement());
        }
        catch (XMLMissingElementException e) {
            throw new ActivitySpecificationException(this.getName(), e.getElement());
        }
        catch (XMLMissingAttributeException e) {
            throw new ActivitySpecificationException(this.getName(), e.getElement() + "." + e.getAttribute());
        }
        catch (Exception e) {
            throw new ActivityCreationException(this.getName(), (Throwable)e);
        }
    }

    public final void processBlock() {
        try {
            Collection collection = null;
            try {
                collection = this.mDataResource.getXMLDBCollection(this.mSubCollectionName, this.mUserCredentials);
            }
            catch (XMLDBUnknownSubCollectionException e) {
                throw new ActivitySpecificationException(this.getName(), (Throwable)e);
            }
            catch (XMLDBCollectionUseException e) {
                throw new ActivityExecutionException(this.getName(), (Throwable)e);
            }
            catch (DAIAuthorizationException e) {
                throw new ActivitySpecificationException(this.getName(), (Throwable)new ActivityAuthorizationException(this.getName(), (Throwable)e));
            }
            catch (AuthorizationExecutionException e) {
                throw new ActivityExecutionException(this.getName(), (Throwable)e);
            }
            catch (Exception e) {
                throw new ActivityExecutionException(this.getName(), (Throwable)e);
            }
            CommandContextImpl context = new CommandContextImpl(collection, this.mContext, this.mOutput);
            try {
                this.mCommand.execute(context);
            }
            catch (XMLDBCommandSpecificationException e) {
                throw new ActivitySpecificationException(this.getName(), (Throwable)((Object)e));
            }
            catch (XMLDBCommandExecutionException e) {
                throw new ActivityExecutionException(this.getName(), (Throwable)((Object)e));
            }
            try {
                this.mDataResource.releaseXMLDBCollection(collection);
            }
            catch (XMLDBCollectionUseException e) {
                throw new ActivityExecutionException(this.getName(), (Throwable)e);
            }
            this.setCompleted();
        }
        catch (ActivitySpecificationException e) {
            this.setError(e);
        }
        catch (ActivityExecutionException e) {
            this.setError(e);
        }
    }
}

