/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.xmldb;

import org.w3c.dom.Element;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLEmptyElementException;
import uk.org.ogsadai.common.xml.XMLMissingElementException;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.dataresource.XMLDBCollectionProvider;

public abstract class XMLDBActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)XMLDBActivity.class);
    protected BlockWriter mOutput;
    protected XMLDBCollectionProvider mDataResource;
    protected String mUserCredentials;
    protected String mSubCollectionName;

    public XMLDBActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        try {
            this.mSubCollectionName = XMLUtilities.parseChildElementValue((Element)element, (String)"http://ogsadai.org.uk/namespaces/2005/10/types", (String)"collection", (boolean)false, (boolean)true);
        }
        catch (XMLEmptyElementException e) {
            throw new ActivitySpecificationException(this.getName(), e.getElement());
        }
        catch (XMLMissingElementException e) {
            throw new ActivitySpecificationException(this.getName(), e.getElement());
        }
        catch (Exception e) {
            throw new ActivityCreationException(this.getName(), (Throwable)e);
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        this.mDataResource = (XMLDBCollectionProvider)this.mContext.getDataResourceAccessor();
        this.mUserCredentials = this.mContext.getSecurityContext().getDN();
        try {
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public abstract void processBlock();
}

