/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.xmldb;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XMLResource;
import uk.org.ogsadai.activity.ActivityAuthorizationException;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.xmldb.XMLDBActivity;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLDocumentException;
import uk.org.ogsadai.common.xml.XMLEmptyElementException;
import uk.org.ogsadai.common.xml.XMLMissingAttributeException;
import uk.org.ogsadai.common.xml.XMLMissingElementException;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.dataresource.XMLDBCollectionUseException;
import uk.org.ogsadai.dataresource.XMLDBUnknownSubCollectionException;
import uk.org.ogsadai.exception.AuthorizationExecutionException;
import uk.org.ogsadai.exception.DAIAuthorizationException;

public class XMLBulkLoadActivity
extends XMLDBActivity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)XMLBulkLoadActivity.class);
    public static final String ELEMENT_FROM_LOCAL = "fromLocal";
    public static final String ELEMENT_OUTPUT = "output";
    public static final String ATTRIBUTE_CREATE = "createIfNotExists";
    public static final String HEADER = "<resourceSet>\n";
    public static final String FOOTER = "</resourceSet>\n";
    private NodeList mResources = null;
    private int mCurrentResource = 0;
    private BlockReader mInput;
    private Collection mCollection;
    private boolean mCreateCollectionIfNotExists = false;

    public XMLBulkLoadActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        try {
            this.mSubCollectionName = XMLUtilities.parseChildElementValue((Element)element, (String)"http://ogsadai.org.uk/namespaces/2005/10/types", (String)"collection", (boolean)false, (boolean)true);
            String create = XMLUtilities.parseChildElementAttribute((Element)element, (String)"http://ogsadai.org.uk/namespaces/2005/10/types", (String)"collection", (String)ATTRIBUTE_CREATE, (boolean)false, (boolean)false);
            this.mCreateCollectionIfNotExists = "true".equalsIgnoreCase(create);
            String input = XMLUtilities.parseChildElementAttribute((Element)element, (String)"http://ogsadai.org.uk/namespaces/2005/10/types", (String)ELEMENT_FROM_LOCAL, (String)"from", (boolean)false, (boolean)false);
            if (input != null) {
                this.mInternalInputs = new String[]{input};
            } else {
                this.mInternalInputs = new String[0];
                this.mResources = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "resource");
            }
            this.mInternalOutputs = new String[]{XMLUtilities.parseChildElementAttribute((Element)element, (String)"http://ogsadai.org.uk/namespaces/2005/10/types", (String)ELEMENT_OUTPUT, (String)"name", (boolean)true, (boolean)true)};
        }
        catch (XMLEmptyElementException e) {
            throw new ActivitySpecificationException(this.getName(), e.getElement());
        }
        catch (XMLMissingElementException e) {
            throw new ActivitySpecificationException(this.getName(), e.getElement());
        }
        catch (XMLMissingAttributeException e) {
            throw new ActivitySpecificationException(this.getName(), e.getElement() + "." + e.getAttribute());
        }
        catch (Exception e) {
            throw new ActivityCreationException(this.getName(), (Throwable)e);
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        if (this.mInternalInputs.length != 0) {
            try {
                this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
            }
            catch (ActivityStreamNotFoundException e) {
                throw new ActivitySpecificationException(this.getName(), (Throwable)e);
            }
        }
    }

    public void processFirst() {
        block12: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("processFirst: enter");
            }
            try {
                try {
                    this.mCollection = this.mDataResource.getXMLDBCollection(this.mSubCollectionName, this.mUserCredentials);
                }
                catch (XMLDBUnknownSubCollectionException e) {
                    if (this.mCreateCollectionIfNotExists) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("processFirst: creating new sub-collection");
                        }
                        Collection baseCollection = this.mDataResource.getXMLDBCollection(this.mUserCredentials);
                        CollectionManagementService service = (CollectionManagementService)baseCollection.getService("CollectionManagementService", "1.0");
                        this.mCollection = service.createCollection(this.mSubCollectionName);
                        break block12;
                    }
                    throw new ActivitySpecificationException(this.getName(), ATTRIBUTE_CREATE, (Throwable)e);
                }
            }
            catch (XMLDBCollectionUseException e) {
                this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            }
            catch (DAIAuthorizationException e) {
                this.setError(new ActivitySpecificationException(this.getName(), (Throwable)new ActivityAuthorizationException(this.getName(), (Throwable)e)));
            }
            catch (AuthorizationExecutionException e) {
                this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            }
            catch (XMLDBException e) {
                this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            }
            catch (Exception e) {
                this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("processFirst: exit");
        }
    }

    public void processBlock() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processBlock: enter");
        }
        if (this.mResources != null) {
            if (this.mCurrentResource < this.mResources.getLength()) {
                try {
                    this.addDocument((Element)this.mResources.item(this.mCurrentResource));
                    ++this.mCurrentResource;
                }
                catch (ActivityExecutionException e) {
                    this.setError(e);
                }
            } else {
                this.mOutput.put((Object)this.resultsToXML(this.mCurrentResource));
                try {
                    this.mDataResource.releaseXMLDBCollection(this.mCollection);
                }
                catch (XMLDBCollectionUseException e) {
                    this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
                }
                this.mOutput.close();
                this.setCompleted();
            }
        } else if (this.mInput != null && this.mInput.hasNext()) {
            String obj = (String)this.mInput.next();
            if (obj.equals(HEADER)) {
                return;
            }
            if (obj.equals(FOOTER)) {
                this.mOutput.put((Object)this.resultsToXML(this.mCurrentResource));
                try {
                    this.mDataResource.releaseXMLDBCollection(this.mCollection);
                }
                catch (XMLDBCollectionUseException e) {
                    this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
                }
                this.mOutput.close();
                this.setCompleted();
                return;
            }
            try {
                ++this.mCurrentResource;
                Document doc = XMLUtilities.xmlStringToDOM((String)obj, (boolean)false);
                this.addDocument(doc.getDocumentElement());
            }
            catch (XMLDocumentException e) {
                this.setError(new ActivitySpecificationException(this.getName(), (Throwable)e));
            }
            catch (XMLParseException e) {
                this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            }
            catch (ActivityExecutionException e) {
                this.setError(e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("processBlock: exit");
        }
    }

    private void addDocument(Element element) throws ActivityExecutionException {
        Element firstChild = (Element)element.getElementsByTagName("*").item(0);
        try {
            XMLResource resource = (XMLResource)this.mCollection.createResource(null, "XMLResource");
            resource.setContentAsDOM((Node)firstChild);
            this.mCollection.storeResource((Resource)resource);
        }
        catch (XMLDBException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)e);
        }
    }

    private String resultsToXML(int numResources) {
        StringBuffer results = new StringBuffer();
        results.append('<');
        results.append("resultCount");
        results.append('>');
        results.append(numResources);
        results.append("</");
        results.append("resultCount");
        results.append('>');
        return results.toString();
    }
}

