/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.transform;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import uk.org.ogsadai.activity.transform.IncrementalProcessor;
import uk.org.ogsadai.common.msgs.DAILogger;

public class ZIPIncrementalProcessor
implements IncrementalProcessor {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)ZIPIncrementalProcessor.class);
    private ZipOutputStream mOutput;
    private Checksum mChecksum;
    private Map mEntryMap;
    private Iterator mEntryNames;
    private InputStream mCurrentInput;
    private String mComment;
    private static final int METHOD = 8;
    private int mLevel = -1;
    private boolean mActive;
    private byte[] mBuffer;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public ZIPIncrementalProcessor() {
        this(4096);
    }

    public ZIPIncrementalProcessor(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize must be > 0");
        }
        this.mBuffer = new byte[bufferSize];
    }

    public void setEntryMap(Map entryMap) {
        if (entryMap == null) {
            throw new IllegalArgumentException("entryMap must not be null");
        }
        if (entryMap.size() < 1) {
            throw new IllegalArgumentException("entryMap must contain at least one entry");
        }
        Iterator i = entryMap.values().iterator();
        while (i.hasNext()) {
            if (i.next() instanceof InputStream) continue;
            throw new IllegalArgumentException("entryMap must only contain java.io.InputStream objects");
        }
        this.mEntryMap = entryMap;
        this.mEntryNames = entryMap.keySet().iterator();
    }

    public void setChecksum(Checksum checksum) {
        this.mChecksum = checksum;
    }

    public void setComment(String comment) {
        if (comment != null && comment.getBytes().length > 65535) {
            throw new IllegalArgumentException("comment must not be null and must not be greater than 0xFFFF in length " + comment.getBytes().length);
        }
        this.mComment = comment;
    }

    public void setLevel(int level) {
        if (level < 0 || level > 9) {
            throw new IllegalArgumentException("level must not be < 0 or > 9");
        }
        this.mLevel = level;
    }

    public void initialise(OutputStream output) {
        this.mOutput = this.mChecksum == null ? new ZipOutputStream(output) : new ZipOutputStream(new CheckedOutputStream(output, this.mChecksum));
        if (this.mComment != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ZIP Comment: " + this.mComment);
            }
            this.mOutput.setComment(this.mComment);
        }
        if (this.mLevel != -1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ZIP Level: " + this.mLevel);
            }
            this.mOutput.setLevel(this.mLevel);
        }
        this.mOutput.setMethod(8);
        this.mActive = true;
    }

    public boolean active() {
        return this.mActive;
    }

    public void process() throws IOException {
        int amount;
        if (LOG.isDebugEnabled()) {
            LOG.debug("process: start");
        }
        if (this.mCurrentInput == null) {
            this.initialiseNextEntry();
        }
        if ((amount = this.mCurrentInput.read(this.mBuffer)) < 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Finished compressiong current entry.");
            }
            this.mOutput.closeEntry();
            this.mCurrentInput.close();
            if (this.mEntryNames.hasNext()) {
                this.initialiseNextEntry();
                this.process();
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Finishing writing output");
                }
                this.mOutput.finish();
                this.mActive = false;
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Writing " + amount + " bytes to the ZIP output.");
            }
            this.mOutput.write(this.mBuffer, 0, amount);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("process: end");
        }
    }

    private void initialiseNextEntry() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("initialiseNextEntry: start");
        }
        if (this.mEntryNames.hasNext()) {
            if (this.mCurrentInput != null) {
                this.mCurrentInput.close();
            }
            String entryName = (String)this.mEntryNames.next();
            this.mCurrentInput = (InputStream)this.mEntryMap.get(entryName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating new zip entry named: " + entryName);
            }
            ZipEntry entry = new ZipEntry(entryName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Putting the new entry into the ZipOutputStream");
            }
            try {
                this.mOutput.putNextEntry(entry);
            }
            catch (ZipException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("initialiseNextEntry: end");
        }
    }

    public void close() throws IOException {
        this.mOutput.flush();
        this.mOutput.close();
        this.mBuffer = new byte[0];
    }
}

