/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.transform;

import java.io.IOException;
import java.util.HashMap;
import java.util.zip.Checksum;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.transform.ChecksumConverter;
import uk.org.ogsadai.activity.transform.IncrementalProcessorInputStream;
import uk.org.ogsadai.activity.transform.ZIPArchiveCommentLengthException;
import uk.org.ogsadai.activity.transform.ZIPIncrementalProcessor;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockReaderInputStream;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.exception.DAIIOException;
import uk.org.ogsadai.exception.DAINumberFormatException;
import uk.org.ogsadai.exception.DAIOutOfBoundsException;

public class ZIPArchiveActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private Checksum mChecksum;
    private BlockWriter mArchivedOutput;
    private BlockWriter mMetadataOutput;
    private final ZIPIncrementalProcessor mProcessor = new ZIPIncrementalProcessor();
    private IncrementalProcessorInputStream mArchivedInput;
    private byte[] mBuffer = new byte[4096];

    public ZIPArchiveActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        NodeList allSettings;
        NodeList commentElements = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "comment");
        if (commentElements.getLength() > 0) {
            String comment = ((Element)commentElements.item(0)).getNodeValue();
            try {
                this.mProcessor.setComment(comment);
            }
            catch (IllegalArgumentException e) {
                throw new ActivitySpecificationException(this.getName(), "comment", (Throwable)((Object)new ZIPArchiveCommentLengthException(comment.getBytes().length)));
            }
        }
        if ((allSettings = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "settings")).getLength() > 0) {
            Element settings = (Element)allSettings.item(0);
            this.mChecksum = ChecksumConverter.convert(settings.getAttribute("checksum"));
            this.mProcessor.setChecksum(this.mChecksum);
            String s = settings.getAttribute("level");
            if (s.length() > 0) {
                int level = 0;
                try {
                    level = Integer.parseInt(s);
                    this.mProcessor.setLevel(Integer.parseInt(s));
                }
                catch (NumberFormatException nfe) {
                    throw new ActivitySpecificationException(this.getName(), "level", (Throwable)new DAINumberFormatException(s));
                }
                catch (IllegalArgumentException e) {
                    throw new ActivitySpecificationException(this.getName(), "level", (Throwable)new DAIOutOfBoundsException(level, 0, 9));
                }
            }
        }
        NodeList inputs = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "zipEntry");
        this.mInternalInputs = new String[inputs.getLength()];
        for (int i = 0; i < inputs.getLength(); ++i) {
            Element zipEntry = (Element)inputs.item(i);
            this.mInternalInputs[i] = zipEntry.getAttribute("from");
        }
        this.mInternalOutputs = new String[2];
        this.mInternalOutputs[0] = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "archivedOutput").item(0)).getAttribute("name");
        this.mInternalOutputs[1] = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "metadataOutput").item(0)).getAttribute("name");
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mArchivedOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
            this.mMetadataOutput = this.mContext.getOutput(this.mInternalOutputs[1]);
            HashMap<String, BlockReaderInputStream> entryMap = new HashMap<String, BlockReaderInputStream>();
            for (int i = 0; i < this.mInternalInputs.length; ++i) {
                BlockReader blockReader = this.mContext.getInput(this.mInternalInputs[i]);
                entryMap.put(this.mInternalInputs[i], new BlockReaderInputStream(blockReader));
            }
            this.mProcessor.setEntryMap(entryMap);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public void processFirst() {
        try {
            this.mArchivedInput = new IncrementalProcessorInputStream(this.mProcessor);
        }
        catch (IOException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e)));
        }
    }

    public void processBlock() {
        try {
            int length = this.mArchivedInput.read(this.mBuffer);
            if (length > 0) {
                byte[] block = new byte[length];
                System.arraycopy(this.mBuffer, 0, block, 0, length);
                this.mArchivedOutput.put((Object)block);
            } else {
                this.mArchivedInput.close();
                this.mMetadataOutput.put((Object)this.getMetadata());
                this.setCompleted();
            }
        }
        catch (IOException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e)));
        }
    }

    private final String getMetadata() {
        StringBuffer s = new StringBuffer();
        s.append("<");
        s.append("zipArchiveMetadata");
        s.append(">\n");
        s.append("  <");
        s.append("checksum");
        s.append(" ");
        s.append("type");
        s.append("=\"");
        s.append(ChecksumConverter.convert(this.mChecksum));
        s.append("\" ");
        s.append("value");
        s.append("=\"");
        s.append(this.mChecksum.getValue());
        s.append("\"/>\n");
        s.append("</");
        s.append("zipArchiveMetadata");
        s.append(">\n");
        return s.toString();
    }
}

