/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.transform;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.SynchronizedGrowablePipe;
import uk.org.ogsadai.activity.transform.MissingXSLTException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockReaderReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.BlockWriterWriter;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.exception.DAIIOException;

public class XSLTransformActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)XSLTransformActivity.class);
    private BlockReader mInputXML;
    private BlockReader mInputXSLT;
    private BlockWriter mOutput;
    private final TransformerFactory mFactory = TransformerFactory.newInstance();

    public XSLTransformActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entering constructor");
        }
        String inputXMLName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "inputXML").item(0)).getAttribute("from");
        String inputXSLTName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "inputXSLT").item(0)).getAttribute("from");
        if (inputXSLTName.trim().equals("")) {
            NodeList elements = element.getElementsByTagNameNS("http://www.w3.org/1999/XSL/Transform", "*");
            if (elements.getLength() <= 0) {
                throw new ActivitySpecificationException(this.getName(), (Throwable)((Object)new MissingXSLTException()));
            }
            Element xsltElement = (Element)elements.item(0);
            String xslt = XMLUtilities.xmlDOMToString((Node)xsltElement);
            this.mInputXSLT = new SynchronizedGrowablePipe();
            ((BlockWriter)this.mInputXSLT).put((Object)xslt);
            ((BlockWriter)this.mInputXSLT).close();
        }
        String outputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "output").item(0)).getAttribute("name");
        this.mInternalInputs = this.mInputXSLT == null ? new String[]{inputXMLName, inputXSLTName} : new String[]{inputXMLName};
        this.mInternalOutputs = new String[]{outputName};
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exiting constructor");
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mInputXML = this.mContext.getInput(this.mInternalInputs[0]);
            if (this.mInputXSLT == null) {
                this.mInputXSLT = this.mContext.getInput(this.mInternalInputs[1]);
            }
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public void processBlock() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entering processBlock()");
        }
        BlockReaderReader xslt = new BlockReaderReader(this.mInputXSLT);
        BlockReaderReader xml = new BlockReaderReader(this.mInputXML);
        BlockWriterWriter results = new BlockWriterWriter(this.mOutput);
        try {
            Transformer transformer = this.mFactory.newTransformer(new StreamSource((Reader)xslt));
            transformer.setOutputProperty("indent", "yes");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Performing the transformation");
            }
            transformer.transform(new StreamSource((Reader)xml), new StreamResult((Writer)results));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Transformation complete");
            }
            xslt.close();
            xml.close();
            results.flush();
            results.close();
            this.mOutput.close();
            this.setCompleted();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Exiting transform()");
            }
        }
        catch (TransformerException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
        }
        catch (IOException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e)));
        }
    }
}

