/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.transform;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.xml.XMLDocumentException;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.exception.DAIProjectionException;
import uk.org.ogsadai.exception.ExternalModuleException;

public class WebRowSetProjectionActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private BlockReader mInput;
    private BlockWriter mOutput;
    private String mAttributeName;
    private int mAttributeIndex;
    private boolean isFirstBlock;
    private int index;
    private DocumentBuilderFactory dbf;

    public WebRowSetProjectionActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        String inputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "webRowSetInput").item(0)).getAttribute("from");
        String outputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "attributeValuesOutput").item(0)).getAttribute("name");
        this.mInternalInputs = new String[]{inputName};
        this.mInternalOutputs = new String[]{outputName};
        NodeList list = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "attributeName");
        if (list.getLength() > 0) {
            this.mAttributeName = list.item(0).getFirstChild().getNodeValue();
        }
        if ((list = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "attributeIndex")).getLength() > 0) {
            this.mAttributeIndex = Integer.parseInt(list.item(0).getFirstChild().getNodeValue());
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
            this.isFirstBlock = true;
            this.dbf = DocumentBuilderFactory.newInstance();
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public void processBlock() {
        block10: {
            if (this.mInput.hasNext()) {
                try {
                    DocumentBuilder db = this.dbf.newDocumentBuilder();
                    if (this.isFirstBlock) {
                        if (this.mAttributeName != null) {
                            this.index = this.handleFirstBlock(this.mInput.next(), db);
                        } else {
                            this.mInput.next();
                        }
                        this.isFirstBlock = false;
                        break block10;
                    }
                    Object inputBlock = this.mInput.next();
                    if (!this.mInput.hasNext()) {
                        this.setCompleted();
                        break block10;
                    }
                    this.handleRestBlocks(inputBlock, db);
                }
                catch (ActivitySpecificationException e) {
                    this.setError(e);
                    this.mOutput.close();
                }
                catch (ActivityExecutionException e) {
                    this.setError(e);
                    this.mOutput.close();
                }
                catch (ParserConfigurationException e) {
                    this.setError(new ActivityExecutionException(this.getName(), (Throwable)new ExternalModuleException((Throwable)e)));
                    this.mOutput.close();
                }
            } else {
                this.setCompleted();
            }
        }
    }

    private int handleFirstBlock(Object inputBlock, DocumentBuilder db) throws ActivitySpecificationException, ActivityExecutionException {
        StringBuffer wellFormedBlock = new StringBuffer();
        int index = -1;
        if (inputBlock instanceof String) {
            wellFormedBlock.append((String)inputBlock);
            wellFormedBlock.append("</data></webRowSet>");
        } else if (inputBlock instanceof byte[]) {
            wellFormedBlock.append((byte[])inputBlock);
            wellFormedBlock.append("</data></webRowSet>");
        } else {
            wellFormedBlock.append(inputBlock.toString());
            wellFormedBlock.append("</data></webRowSet>");
        }
        byte[] bytes = wellFormedBlock.toString().getBytes();
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        Document doc = null;
        try {
            doc = db.parse(bis);
        }
        catch (SAXParseException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)new XMLDocumentException(e));
        }
        catch (SAXException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)new XMLParseException(e));
        }
        catch (IOException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)new XMLParseException(e));
        }
        NodeList nlist = doc.getElementsByTagName("column-name");
        for (int i = 0; i < nlist.getLength(); ++i) {
            if (!nlist.item(i).getFirstChild().getNodeValue().equals(this.mAttributeName)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)new DAIProjectionException("WebRowSet", this.mAttributeName));
        }
        nlist = doc.getElementsByTagName("column-index");
        if (nlist.getLength() > 0) {
            index = Integer.parseInt(nlist.item(index).getFirstChild().getNodeValue());
        }
        return index;
    }

    /*
     * WARNING - void declaration
     */
    private void handleRestBlocks(Object inputBlock, DocumentBuilder db) throws ActivitySpecificationException, ActivityExecutionException {
        byte[] bytes = inputBlock instanceof String ? ((String)inputBlock).getBytes() : (inputBlock instanceof byte[] ? new String((byte[])inputBlock).getBytes() : new String(inputBlock.toString()).getBytes());
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        Document doc = null;
        try {
            doc = db.parse(bis);
        }
        catch (SAXParseException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)new XMLDocumentException(e));
        }
        catch (SAXException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)new XMLParseException(e));
        }
        catch (IOException e) {
            throw new ActivityExecutionException(this.getName(), (Throwable)new XMLParseException(e));
        }
        NodeList nlist = doc.getElementsByTagName("columnValue");
        if (nlist.getLength() > 0) {
            void var3_10;
            String outputBlock;
            if (this.mAttributeName != null) {
                outputBlock = nlist.item(this.index - 1).getFirstChild().getNodeValue();
            } else if (nlist.item(this.mAttributeIndex - 1) != null) {
                outputBlock = nlist.item(this.mAttributeIndex - 1).getFirstChild().getNodeValue();
            } else {
                throw new ActivitySpecificationException(this.getName(), (Throwable)new DAIProjectionException("WebRowSet", this.mAttributeIndex));
            }
            this.mOutput.put((Object)var3_10);
        }
    }
}

