/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.transform;

import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;

public class StringTokenizerActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private BlockReader mInput;
    private BlockWriter mOutput;
    private String mDelimiters;
    private StringTokenizer mTokenizer;

    public StringTokenizerActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        String inputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "stringBlocksInput").item(0)).getAttribute("from");
        String outputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "stringTokensOutput").item(0)).getAttribute("name");
        this.mInternalInputs = new String[]{inputName};
        this.mInternalOutputs = new String[]{outputName};
        NodeList list = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "delimiters");
        this.mDelimiters = list.getLength() > 0 ? ((Element)list.item(0)).getAttribute("value") : " ";
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public void processBlock() {
        this.maintainTokenizer();
        if (this.mTokenizer.hasMoreTokens()) {
            String token = this.mTokenizer.nextToken();
            this.mOutput.put((Object)token);
        } else {
            this.setCompleted();
        }
    }

    private final void maintainTokenizer() {
        if ((this.mTokenizer == null || !this.mTokenizer.hasMoreTokens()) && this.mInput.hasNext()) {
            Object block = this.mInput.next();
            this.mTokenizer = block instanceof String ? new StringTokenizer((String)block, this.mDelimiters) : (block instanceof byte[] ? new StringTokenizer(new String((byte[])block), this.mDelimiters) : new StringTokenizer(block.toString()));
        }
    }
}

