/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.transform;

import java.util.Random;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.exception.DAINumberFormatException;
import uk.org.ogsadai.exception.DAIOutOfBoundsException;

public class RandomSampleActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private BlockReader mInput;
    private BlockWriter mOutput;
    private float fraction;
    private boolean is_seed;
    private long seed;
    private Random ra;

    public RandomSampleActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        String inputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "inputValues").item(0)).getAttribute("from");
        String outputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "sampleOutput").item(0)).getAttribute("name");
        this.mInternalInputs = new String[]{inputName};
        this.mInternalOutputs = new String[]{outputName};
        NodeList list = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "fraction");
        if (list.getLength() > 0) {
            String fractionString = list.item(0).getFirstChild().getNodeValue();
            try {
                this.fraction = Float.parseFloat(fractionString);
            }
            catch (NumberFormatException e) {
                throw new ActivitySpecificationException(this.getName(), "fraction", (Throwable)new DAINumberFormatException(fractionString));
            }
        }
        if (this.fraction < 0.0f || this.fraction > 1.0f) {
            throw new ActivitySpecificationException(this.getName(), "fraction", (Throwable)new DAIOutOfBoundsException(this.fraction, 0.0f, 1.0f));
        }
        list = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "seed");
        if (list.getLength() > 0) {
            this.is_seed = true;
            String seedString = list.item(0).getFirstChild().getNodeValue();
            try {
                this.seed = Long.parseLong(seedString);
            }
            catch (NumberFormatException e) {
                throw new ActivitySpecificationException(this.getName(), "seed", (Throwable)new DAINumberFormatException(seedString));
            }
        } else {
            this.is_seed = false;
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
        this.ra = this.is_seed ? new Random(this.seed) : new Random();
    }

    public void processBlock() {
        if (this.mInput.hasNext()) {
            double temp = this.ra.nextDouble();
            Object inputBlock = this.mInput.next();
            if (temp < (double)this.fraction) {
                if (inputBlock instanceof String) {
                    String outputBlock = (String)inputBlock;
                    this.mOutput.put((Object)outputBlock);
                } else if (inputBlock instanceof byte[]) {
                    String outputBlock = new String((byte[])inputBlock);
                    this.mOutput.put((Object)outputBlock);
                } else {
                    String outputBlock = inputBlock.toString();
                    this.mOutput.put((Object)outputBlock);
                }
            }
        } else {
            this.setCompleted();
        }
    }
}

