/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.transform;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.org.ogsadai.activity.transform.ByteQueue;
import uk.org.ogsadai.activity.transform.IncrementalProcessor;

public class IncrementalProcessorInputStream
extends InputStream {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private ByteQueue mQueue;
    private IncrementalProcessor mProcessor;
    private byte[] mByte = new byte[1];

    public IncrementalProcessorInputStream(IncrementalProcessor processor) throws IOException {
        this(processor, 4096);
    }

    public IncrementalProcessorInputStream(IncrementalProcessor processor, int bufferSize) throws IOException {
        this.mQueue = new ByteQueue(bufferSize);
        this.mProcessor = processor;
        this.mProcessor.initialise(new QueueSharingOutputStream());
    }

    public int read() throws IOException {
        int i = this.read(this.mByte, 0, 1);
        if (i > 0) {
            i = this.mByte[0];
        }
        return i;
    }

    public int read(byte[] bytes, int start, int length) throws IOException {
        while (this.mProcessor.active() && this.mQueue.available() < length) {
            this.mProcessor.process();
        }
        if ((length = this.mQueue.dequeue(bytes, start, length)) == 0) {
            length = -1;
            this.mQueue.empty();
            this.mProcessor.close();
        }
        return length;
    }

    private class QueueSharingOutputStream
    extends OutputStream {
        private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";

        private QueueSharingOutputStream() {
        }

        public void write(int b) throws IOException {
            ((IncrementalProcessorInputStream)IncrementalProcessorInputStream.this).mByte[0] = (byte)b;
            this.write(IncrementalProcessorInputStream.this.mByte, 0, 1);
        }

        public void write(byte[] bytes, int start, int length) throws IOException {
            IncrementalProcessorInputStream.this.mQueue.enqueue(bytes, start, length);
        }
    }
}

