/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.transform;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import java.util.zip.GZIPOutputStream;
import uk.org.ogsadai.activity.transform.IncrementalProcessor;

public class GZIPIncrementalProcessor
implements IncrementalProcessor {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private InputStream mInput;
    private GZIPOutputStream mOutput;
    private Checksum mChecksum;
    private boolean mActive;
    private byte[] mBuffer;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public GZIPIncrementalProcessor(InputStream input, Checksum checksum) {
        this(input, checksum, 4096);
    }

    public GZIPIncrementalProcessor(InputStream input, Checksum checksum, int bufferSize) {
        this.mInput = input;
        this.mChecksum = checksum;
        this.mBuffer = new byte[bufferSize];
    }

    public void initialise(OutputStream output) throws IOException {
        this.mOutput = this.mChecksum == null ? new GZIPOutputStream(output) : new GZIPOutputStream(new CheckedOutputStream(output, this.mChecksum));
        this.mActive = true;
    }

    public boolean active() {
        return this.mActive;
    }

    public void process() throws IOException {
        int length = this.mInput.read(this.mBuffer, 0, this.mBuffer.length);
        if (length == -1) {
            this.mOutput.finish();
            this.mActive = false;
        } else {
            this.mOutput.write(this.mBuffer, 0, length);
        }
    }

    public void close() throws IOException {
        this.mInput.close();
        this.mOutput.close();
        this.mBuffer = new byte[0];
    }
}

