/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.transform;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import java.util.zip.GZIPInputStream;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.transform.ChecksumConverter;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockReaderInputStream;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.exception.DAIIOException;

public class GZIPDecompressionActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private BlockReader mCompressedInput;
    private BlockWriter mDecompressedOutput;
    private BlockWriter mMetadataOutput;
    private GZIPInputStream mDecompressedOutputStream;
    private Checksum mChecksum;

    public GZIPDecompressionActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        NodeList allSettings = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "settings");
        if (allSettings.getLength() != 0) {
            Element settings = (Element)allSettings.item(0);
            this.mChecksum = ChecksumConverter.convert(settings.getAttribute("checksum"));
        }
        String from = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "input").item(0)).getAttribute("from");
        this.mInternalInputs = new String[]{from};
        this.mInternalOutputs = new String[2];
        this.mInternalOutputs[0] = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "decompressedOutput").item(0)).getAttribute("name");
        this.mInternalOutputs[1] = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "metadataOutput").item(0)).getAttribute("name");
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mCompressedInput = this.mContext.getInput(this.mInternalInputs[0]);
            this.mDecompressedOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
            this.mMetadataOutput = this.mContext.getOutput(this.mInternalOutputs[1]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public void processFirst() {
        BlockReaderInputStream input = new BlockReaderInputStream(this.mCompressedInput);
        try {
            this.mDecompressedOutputStream = this.mChecksum == null ? new GZIPInputStream((InputStream)input) : new GZIPInputStream(new CheckedInputStream((InputStream)input, this.mChecksum));
        }
        catch (IOException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e)));
        }
    }

    public void processBlock() {
        byte[] readBytes = new byte[4096];
        try {
            int numBytes = this.mDecompressedOutputStream.read(readBytes, 0, readBytes.length);
            if (numBytes > 0) {
                byte[] block;
                if (numBytes < readBytes.length) {
                    block = new byte[numBytes];
                    System.arraycopy(readBytes, 0, block, 0, numBytes);
                } else {
                    block = readBytes;
                }
                this.mDecompressedOutput.put((Object)block);
            } else {
                this.mDecompressedOutputStream.close();
                this.mDecompressedOutput.close();
                this.mMetadataOutput.put((Object)this.getMetadata());
                this.mMetadataOutput.close();
                this.setCompleted();
            }
        }
        catch (IOException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e)));
        }
    }

    private final String getMetadata() {
        StringBuffer s = new StringBuffer();
        if (this.mChecksum == null) {
            s.append("<");
            s.append("gzipDecompressionMetadata");
            s.append("/>");
            return s.toString();
        }
        s.append("<");
        s.append("gzipDecompressionMetadata");
        s.append(">\n");
        s.append("  <");
        s.append("checksum");
        s.append(" ");
        s.append("type");
        s.append("=\"");
        s.append(ChecksumConverter.convert(this.mChecksum));
        s.append("\" ");
        s.append("value");
        s.append("=\"");
        s.append(this.mChecksum.getValue());
        s.append("\"/>\n");
        s.append("</");
        s.append("gzipDecompressionMetadata");
        s.append(">\n");
        return s.toString();
    }
}

