/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.transform;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Checksum;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.transform.ChecksumConverter;
import uk.org.ogsadai.activity.transform.GZIPIncrementalProcessor;
import uk.org.ogsadai.activity.transform.IncrementalProcessorInputStream;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockReaderInputStream;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.exception.DAIIOException;

public class GZIPCompressionActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private BlockReader mInput;
    private BlockWriter mCompressedOutput;
    private BlockWriter mMetadataOutput;
    private Checksum mChecksum;
    private IncrementalProcessorInputStream mCompressedInput;
    private byte[] mBuffer = new byte[4096];

    public GZIPCompressionActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        NodeList allSettings = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "settings");
        if (allSettings.getLength() != 0) {
            Element settings = (Element)allSettings.item(0);
            this.mChecksum = ChecksumConverter.convert(settings.getAttribute("checksum"));
        }
        String from = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "input").item(0)).getAttribute("from");
        this.mInternalInputs = new String[]{from};
        this.mInternalOutputs = new String[2];
        this.mInternalOutputs[0] = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "compressedOutput").item(0)).getAttribute("name");
        this.mInternalOutputs[1] = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "metadataOutput").item(0)).getAttribute("name");
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
            this.mCompressedOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
            this.mMetadataOutput = this.mContext.getOutput(this.mInternalOutputs[1]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public void processFirst() {
        try {
            this.mCompressedInput = new IncrementalProcessorInputStream(new GZIPIncrementalProcessor((InputStream)new BlockReaderInputStream(this.mInput), this.mChecksum));
        }
        catch (IOException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e)));
        }
    }

    public void processBlock() {
        try {
            int length = this.mCompressedInput.read(this.mBuffer);
            if (length > 0) {
                byte[] block = new byte[length];
                System.arraycopy(this.mBuffer, 0, block, 0, length);
                this.mCompressedOutput.put((Object)block);
            } else {
                this.mCompressedInput.close();
                this.mMetadataOutput.put((Object)this.getMetadata());
                this.setCompleted();
            }
        }
        catch (IOException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e)));
        }
    }

    private final String getMetadata() {
        StringBuffer s = new StringBuffer();
        s.append("<");
        s.append("gzipCompressionMetadata");
        s.append(">\n");
        s.append("  <");
        s.append("checksum");
        s.append(" ");
        s.append("type");
        s.append("=\"");
        s.append(ChecksumConverter.convert(this.mChecksum));
        s.append("\" ");
        s.append("value");
        s.append("=\"");
        s.append(this.mChecksum.getValue());
        s.append("\"/>\n");
        s.append("</");
        s.append("gzipCompressionMetadata");
        s.append(">\n");
        return s.toString();
    }
}

