/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.transform;

import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.UnsupportedBlockException;
import uk.org.ogsadai.exception.DAINumberFormatException;

public class FrequencyDistributorActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private BlockReader mInput;
    private BlockWriter mOutput;
    private int[] mAttributeSequence;
    private int[] mDistributionArray;

    public FrequencyDistributorActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        String inputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "inputValues").item(0)).getAttribute("from");
        String outputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "distributionOutput").item(0)).getAttribute("name");
        this.mInternalInputs = new String[]{inputName};
        this.mInternalOutputs = new String[]{outputName};
        NodeList list = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "pointsValues");
        String temp = new String();
        if (list.getLength() > 0) {
            temp = list.item(0).getFirstChild().getNodeValue();
        }
        StringTokenizer st = new StringTokenizer(temp, ",");
        int len = st.countTokens();
        int i = 0;
        this.mAttributeSequence = new int[len];
        while (st.hasMoreTokens()) {
            String nextInt = st.nextToken();
            try {
                this.mAttributeSequence[i] = Integer.parseInt(nextInt);
            }
            catch (NumberFormatException nfe) {
                throw new ActivitySpecificationException(this.getName(), "pointsValues", (Throwable)new DAINumberFormatException(nextInt));
            }
            ++i;
        }
        this.mDistributionArray = new int[len - 1 + 2];
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public void processBlock() {
        int index = 0;
        if (this.mInput.hasNext()) {
            Object inputBlock = this.mInput.next();
            try {
                index = inputBlock instanceof String ? this.findSpace(this.mAttributeSequence, Integer.parseInt((String)inputBlock)) : (inputBlock instanceof byte[] ? this.findSpace(this.mAttributeSequence, Integer.parseInt(new String((byte[])inputBlock))) : this.findSpace(this.mAttributeSequence, Integer.parseInt(inputBlock.toString())));
                int n = index;
                this.mDistributionArray[n] = this.mDistributionArray[n] + 1;
            }
            catch (NumberFormatException nfe) {
                this.setError(new ActivitySpecificationException(this.getName(), (Throwable)new UnsupportedBlockException(inputBlock.getClass().getName())));
            }
        } else {
            StringBuffer outputBlock = new StringBuffer();
            int numDistribs = this.mDistributionArray.length;
            for (int i = 0; i < numDistribs; ++i) {
                if (i != this.mDistributionArray.length - 1) {
                    outputBlock.append(String.valueOf(this.mDistributionArray[i]));
                    outputBlock.append(",");
                    continue;
                }
                outputBlock.append(String.valueOf(this.mDistributionArray[i]));
            }
            this.mOutput.put((Object)outputBlock.toString());
            this.setCompleted();
        }
    }

    private int findSpace(int[] array, int target) {
        int high = array.length;
        int low = -1;
        while (high - low > 1) {
            int probe = (high + low) / 2;
            if (array[probe] > target) {
                high = probe;
                continue;
            }
            low = probe;
        }
        if (low == -1) {
            return 0;
        }
        return low + 1;
    }
}

