/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.transform;

import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.transform.IllegalDelimiterException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.exception.DAIProjectionException;

public class CSVProjectionActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private BlockReader mInput;
    private BlockWriter mOutput;
    private int columnNo;
    private String delim;

    public CSVProjectionActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        String inputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "csvInput").item(0)).getAttribute("from");
        String outputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "columnOutput").item(0)).getAttribute("name");
        this.mInternalInputs = new String[]{inputName};
        this.mInternalOutputs = new String[]{outputName};
        NodeList list = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "columnNo");
        if (list.getLength() > 0) {
            this.columnNo = Integer.parseInt(list.item(0).getFirstChild().getNodeValue());
        }
        if ((list = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "delimeter")).getLength() > 0) {
            this.delim = list.item(0).getFirstChild().getNodeValue();
            if (this.delim.length() > 1 || this.delim.equals("\"")) {
                throw new ActivitySpecificationException(this.getName(), "delimeter", (Throwable)((Object)new IllegalDelimiterException(this.delim)));
            }
        } else {
            this.delim = ",";
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public void processBlock() {
        if (this.mInput.hasNext()) {
            Object inputBlock = this.mInput.next();
            try {
                String inputString = inputBlock instanceof String ? (String)inputBlock : (inputBlock instanceof byte[] ? new String((byte[])inputBlock) : inputBlock.toString());
                String outputBlock = this.findValue(inputString);
                this.mOutput.put((Object)outputBlock);
            }
            catch (ActivitySpecificationException e) {
                this.setError(e);
                this.mOutput.close();
            }
        } else {
            this.setCompleted();
        }
    }

    private String findValue(String input) throws ActivitySpecificationException {
        int i;
        String replaceQuotes = "temp" + String.valueOf(System.currentTimeMillis());
        input = input.replaceAll("\"\"", replaceQuotes);
        StringTokenizer st = new StringTokenizer(input, this.delim);
        String res = new String();
        String temp = new String();
        for (i = 0; i < this.columnNo && st.hasMoreTokens(); ++i) {
            res = st.nextToken();
            while (!res.endsWith("\"")) {
                temp = st.nextToken();
                res = res + this.delim + temp;
            }
            res = res.replaceAll("\"", "");
        }
        if (this.columnNo > i) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)new DAIProjectionException("CSV", this.columnNo));
        }
        if (res.indexOf(replaceQuotes) > 0) {
            res = res.replaceAll(replaceQuotes, "\"");
        }
        return res;
    }
}

