/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.transform;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.UnsupportedBlockException;
import uk.org.ogsadai.common.files.DAIFileWriteIOException;
import uk.org.ogsadai.common.msgs.DAILogger;

public class BytesToTempFileActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)BytesToTempFileActivity.class);
    public static final String INPUT_ELEMENT = "input";
    public static final String OUTPUT_ELEMENT = "output";
    public static final String FROM_ATTRIBUTE = "from";
    public static final String NAME_ATTRIBUTE = "name";
    protected String mInputStreamName;
    protected BlockReader mInput;
    protected String mOutputStreamName;
    protected BlockWriter mOutput;
    protected File mOutputFile = null;
    protected OutputStream mFileOutputStream = null;

    public BytesToTempFileActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        NodeList nodelist = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", INPUT_ELEMENT);
        if (nodelist == null || nodelist.getLength() == 0) {
            throw new ActivitySpecificationException(this.getName(), INPUT_ELEMENT);
        }
        this.mInputStreamName = ((Element)nodelist.item(0)).getAttribute(FROM_ATTRIBUTE);
        this.mInternalInputs = new String[]{this.mInputStreamName};
        nodelist = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", OUTPUT_ELEMENT);
        if (nodelist == null || nodelist.getLength() == 0) {
            throw new ActivitySpecificationException(this.getName(), OUTPUT_ELEMENT);
        }
        this.mOutputStreamName = ((Element)nodelist.item(0)).getAttribute(NAME_ATTRIBUTE);
        this.mInternalOutputs = new String[]{this.mOutputStreamName};
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public String getInputStreamName() {
        return this.mInputStreamName;
    }

    public String getOutputStreamName() {
        return this.mOutputStreamName;
    }

    protected void processBlock() {
        try {
            if (this.mFileOutputStream == null) {
                this.mOutputFile = File.createTempFile("ogsadai", ".tmp");
                this.mFileOutputStream = new FileOutputStream(this.mOutputFile);
            }
            if (this.mInput.hasNext()) {
                Object block = this.mInput.next();
                if (block instanceof byte[]) {
                    this.mFileOutputStream.write((byte[])block);
                } else {
                    this.setError(new ActivitySpecificationException(this.getName(), (Throwable)new UnsupportedBlockException(block.getClass().getName())));
                }
            } else {
                this.mFileOutputStream.close();
                this.mOutput.put((Object)this.mOutputFile);
                this.setCompleted();
            }
        }
        catch (IOException e) {
            DAIFileWriteIOException ioException = new DAIFileWriteIOException(this.mOutputFile, e);
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)ioException));
        }
    }
}

