/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.transform;

public class ByteQueue {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static final int DEFAULT_QUEUE_CAPACITY = 4096;
    private byte[] mQueue;
    private int mHead;
    private int mEnd;
    private int mAvailable;

    public ByteQueue() {
        this(4096);
    }

    public ByteQueue(int queueCapacity) {
        this.mQueue = new byte[queueCapacity];
    }

    public void empty() {
        this.mQueue = new byte[0];
        this.mHead = 0;
        this.mEnd = 0;
        this.mAvailable = 0;
    }

    public void enqueue(byte[] bytes, int index, int length) {
        if (this.mEnd + length > this.mQueue.length) {
            byte[] newQueue = new byte[this.mQueue.length * 2 + length];
            System.arraycopy(this.mQueue, 0, newQueue, 0, this.mQueue.length);
            this.mQueue = newQueue;
        }
        System.arraycopy(bytes, index, this.mQueue, this.mEnd, length);
        this.mEnd += length;
        this.mAvailable += length;
    }

    public int dequeue(byte[] bytes, int start, int length) {
        if (length > this.mAvailable) {
            length = this.mAvailable;
        }
        System.arraycopy(this.mQueue, this.mHead, bytes, start, length);
        this.mHead += length;
        this.mAvailable -= length;
        if (this.mHead > this.mQueue.length / 2) {
            System.arraycopy(this.mQueue, this.mHead, this.mQueue, 0, this.available());
            this.mEnd -= this.mHead;
            this.mHead = 0;
        }
        return length;
    }

    public int available() {
        return this.mAvailable;
    }
}

