/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.transform;

import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.transform.BlockAggregatorSizeException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.MemoryUtilities;
import uk.org.ogsadai.common.UnsupportedBlockException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.exception.DAINumberFormatException;

public class BlockAggregatorActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)BlockAggregatorActivity.class);
    private BlockReader mInput;
    private BlockWriter mOutput;
    private int mBlockSize;

    public BlockAggregatorActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        String inputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "input").item(0)).getAttribute("from");
        String outputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "output").item(0)).getAttribute("name");
        this.mInternalInputs = new String[]{inputName};
        this.mInternalOutputs = new String[]{outputName};
        Element blocksize = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "blocksize").item(0);
        String blockSizeString = blocksize.getAttribute("size");
        try {
            this.mBlockSize = Integer.parseInt(blockSizeString);
        }
        catch (NumberFormatException e) {
            throw new ActivitySpecificationException(this.getName(), "size", (Throwable)new DAINumberFormatException(blockSizeString));
        }
        if (this.mBlockSize <= 0) {
            throw new ActivitySpecificationException(this.getName(), "size", (Throwable)((Object)new BlockAggregatorSizeException(this.mBlockSize)));
        }
    }

    public void processBlock() {
        Object block = null;
        try {
            if (this.mInput.hasNext()) {
                block = this.mInput.next();
                if (block instanceof String) {
                    block = this.processBlocks((String)block);
                    this.mOutput.put(block);
                } else {
                    this.setError(new ActivitySpecificationException(this.getName(), (Throwable)new UnsupportedBlockException(block.getClass().getName())));
                }
            } else {
                this.mOutput.close();
                this.setCompleted();
            }
        }
        catch (ActivitySpecificationException e) {
            this.setError(e);
            this.mOutput.close();
        }
        catch (Exception e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            this.mOutput.close();
        }
    }

    protected Object processBlocks(String string) throws ActivitySpecificationException {
        StringBuffer aggregateBlock = new StringBuffer(string);
        for (int i = 1; i < this.mBlockSize; ++i) {
            Object block = null;
            try {
                if (!this.mInput.hasNext()) break;
                block = this.mInput.next();
                string = (String)block;
                MemoryUtilities.checkMemory((String)string, (DAILogger)LOG);
                aggregateBlock.append(string);
                continue;
            }
            catch (ClassCastException e) {
                throw new ActivitySpecificationException(this.getName(), (Throwable)new UnsupportedBlockException(block.getClass().getName()));
            }
        }
        return aggregateBlock.toString();
    }

    protected Object processBlocks(Node node) throws ActivitySpecificationException {
        DocumentFragment fragment = null;
        if (!(node instanceof DocumentFragment)) {
            Document document = XMLUtilities.createEmptyDocument();
            fragment = document.createDocumentFragment();
            fragment.appendChild(node);
        } else {
            fragment = (DocumentFragment)node;
        }
        Object block = null;
        for (int i = 1; i < this.mBlockSize; ++i) {
            try {
                block = this.mInput.next();
                node = (Node)block;
                fragment.appendChild(node);
                continue;
            }
            catch (ClassCastException e) {
                throw new ActivitySpecificationException(this.getName(), (Throwable)new UnsupportedBlockException(block.getClass().getName()));
            }
        }
        return fragment;
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }
}

