/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.sql.statement;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import uk.org.ogsadai.activity.sql.parameters.MissingParametersException;
import uk.org.ogsadai.activity.sql.parameters.ParameterAccessException;
import uk.org.ogsadai.activity.sql.parameters.ParameterList;
import uk.org.ogsadai.activity.sql.statement.SQLStatement;
import uk.org.ogsadai.common.files.DAIFileNotFoundException;
import uk.org.ogsadai.common.msgs.DAILogger;

public class ParameterisedSQLStatement
implements SQLStatement {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)ParameterisedSQLStatement.class);
    private Connection mConnection;
    private ParameterList mParameters;
    private String mExpression;
    protected PreparedStatement mStatement;
    private boolean mFinishedProcessing = false;
    private List mTempFiles = new LinkedList();
    private List mTempFileInputStreams = new LinkedList();

    public ParameterisedSQLStatement() {
    }

    public ParameterisedSQLStatement(Connection conx, ParameterList parameters, String expression) throws SQLException {
        this.mParameters = parameters;
        this.mExpression = expression;
        this.mStatement = conx.prepareStatement(expression);
        this.mFinishedProcessing = false;
    }

    public void initialise() throws SQLException {
        this.mStatement = this.mConnection.prepareStatement(this.mExpression);
    }

    public void setConnection(Connection connection) {
        this.mConnection = connection;
    }

    public Connection getConnection() {
        return this.mConnection;
    }

    public void setExpression(String expression) {
        this.mExpression = expression;
    }

    public String getExpression() {
        return this.mExpression;
    }

    public void setParameters(ParameterList parameters) {
        this.mParameters = parameters;
    }

    public ParameterList getParameters() {
        return this.mParameters;
    }

    public void close() throws SQLException {
        if (this.mStatement != null) {
            this.mStatement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery() throws SQLException, MissingParametersException, ParameterAccessException {
        if (this.mFinishedProcessing) {
            return null;
        }
        ResultSet result = null;
        this.prepareParameters();
        if (this.mParameters.allStreamsClosed()) {
            this.mFinishedProcessing = true;
        } else {
            try {
                result = this.mStatement.executeQuery();
            }
            finally {
                this.closeTempFilesAndInputStreams();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException, MissingParametersException, ParameterAccessException {
        if (this.mFinishedProcessing) {
            return -1;
        }
        int result = -1;
        this.prepareParameters();
        if (this.mParameters.allStreamsClosed()) {
            this.mFinishedProcessing = true;
        } else {
            try {
                result = this.mStatement.executeUpdate();
            }
            finally {
                this.closeTempFilesAndInputStreams();
            }
        }
        return result;
    }

    protected void prepareParameters() throws SQLException, MissingParametersException, ParameterAccessException {
        try {
            this.prepareParametersPrivate();
        }
        catch (SQLException e) {
            this.closeTempFilesAndInputStreams();
            throw e;
        }
        catch (MissingParametersException e) {
            this.closeTempFilesAndInputStreams();
            throw e;
        }
        catch (ParameterAccessException e) {
            this.closeTempFilesAndInputStreams();
            throw e;
        }
    }

    private void prepareParametersPrivate() throws SQLException, MissingParametersException, ParameterAccessException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Clearing Prepared Statement Parameters");
        }
        this.mStatement.clearParameters();
        if (this.mParameters == null) {
            return;
        }
        int numParameters = this.mParameters.getLength();
        for (int position = 1; position < numParameters; ++position) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("SQLParameter position = " + position);
            }
            Object currentObject = this.mParameters.getParameterObject(position);
            if (LOG.isDebugEnabled()) {
                LOG.debug("What type of Object have I obtained?");
            }
            if (currentObject == null) {
                this.mStatement.setString(position, null);
                continue;
            }
            if (currentObject instanceof Clob) {
                long length = ((Clob)currentObject).length();
                String str = ((Clob)currentObject).getSubString(1L, (int)length);
                this.mStatement.setString(position, str);
                continue;
            }
            if (currentObject instanceof Blob) {
                long length = ((Blob)currentObject).length();
                byte[] bytes = ((Blob)currentObject).getBytes(1L, (int)length);
                this.mStatement.setBytes(position, bytes);
                continue;
            }
            if (currentObject instanceof String) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Parameter at position " + position + " is a string");
                }
                currentObject = ((String)currentObject).trim();
                this.mStatement.setObject(position, currentObject);
                continue;
            }
            if (currentObject instanceof byte[]) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Parameter at position " + position + " is byte array");
                }
                this.mStatement.setBytes(position, (byte[])currentObject);
                continue;
            }
            if (currentObject instanceof File) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Parameter at position " + position + " is a File");
                }
                File file = (File)currentObject;
                try {
                    FileInputStream is = new FileInputStream(file);
                    this.mStatement.setBinaryStream(position, (InputStream)is, (int)file.length());
                    this.mTempFileInputStreams.add(is);
                    this.mTempFiles.add(file);
                    continue;
                }
                catch (FileNotFoundException e) {
                    DAIFileNotFoundException fileNotFoundException = new DAIFileNotFoundException(file);
                    throw new ParameterAccessException(position, fileNotFoundException);
                }
            }
            if (currentObject instanceof BigInteger) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Parameter at position " + position + " is a BigInteger");
                }
                int intValue = ((BigInteger)currentObject).intValue();
                this.mStatement.setInt(position, intValue);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parameter at position " + position + " is not a String or ByteArray so using " + "setObject method. Hope DBMS Driver copes with " + "this type of Object properly. ");
            }
            this.mStatement.setObject(position, currentObject);
        }
    }

    protected void closeTempFilesAndInputStreams() {
        InputStream is = null;
        Iterator it = this.mTempFileInputStreams.iterator();
        while (it.hasNext()) {
            is = (InputStream)it.next();
            try {
                is.close();
            }
            catch (IOException e) {}
        }
        File file = null;
        it = this.mTempFiles.iterator();
        while (it.hasNext()) {
            file = (File)it.next();
            file.delete();
        }
    }
}

