/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.sql.statement;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import uk.org.ogsadai.activity.sql.parameters.MissingParametersException;
import uk.org.ogsadai.activity.sql.parameters.ParameterAccessException;
import uk.org.ogsadai.activity.sql.parameters.ParameterList;
import uk.org.ogsadai.activity.sql.statement.ParameterisedSQLStatement;
import uk.org.ogsadai.common.msgs.DAILogger;

public class CallableSQLStatement
extends ParameterisedSQLStatement {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)CallableSQLStatement.class);
    private boolean mFinishedProcessing = false;
    private int mUpdateCount;
    private boolean mFirstCall;
    private Map mOutParams = new HashMap();
    private boolean mNewCall;

    public CallableSQLStatement() {
    }

    public CallableSQLStatement(Connection conx, ParameterList parameters, String expression) throws SQLException {
        super.setParameters(parameters);
        super.setExpression(expression);
        this.mStatement = conx.prepareCall(expression);
    }

    public void initialise() throws SQLException {
        this.mStatement = this.getConnection().prepareCall(this.getExpression());
        this.registerOutParameters();
    }

    public void registerOutParameter(int position, int type) {
        this.mOutParams.put(new Integer(position), new Integer(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException, MissingParametersException, ParameterAccessException {
        if (this.mFinishedProcessing) {
            return false;
        }
        boolean result = false;
        if (this.getParameters() != null) {
            this.prepareParameters();
            if (this.getParameters().allStreamsClosed()) {
                this.mFinishedProcessing = true;
                return false;
            }
        } else {
            this.mFinishedProcessing = true;
        }
        this.mNewCall = true;
        try {
            result = this.mStatement.execute();
        }
        finally {
            this.closeTempFilesAndInputStreams();
        }
        return result;
    }

    public boolean getMoreResults() throws SQLException, MissingParametersException, ParameterAccessException {
        if (this.mFinishedProcessing) {
            return false;
        }
        if (this.mFirstCall) {
            this.mFirstCall = false;
            return this.execute();
        }
        this.mNewCall = false;
        boolean isResultset = this.mStatement.getMoreResults();
        if (!isResultset) {
            this.mUpdateCount = this.mStatement.getUpdateCount();
            if (this.mUpdateCount == -1) {
                isResultset = this.execute();
            }
        }
        return isResultset;
    }

    public ResultSet getNextResultSet() throws SQLException {
        if (this.mFinishedProcessing) {
            return null;
        }
        return this.mStatement.getResultSet();
    }

    public int getNextUpdateCount() throws SQLException {
        if (this.mFinishedProcessing) {
            return -1;
        }
        if (this.mUpdateCount == -1) {
            this.mUpdateCount = this.mStatement.getUpdateCount();
        }
        return this.mUpdateCount;
    }

    public Map getOutParameters() throws SQLException {
        if (!this.mNewCall || this.mOutParams.size() == 0) {
            return null;
        }
        HashMap<Integer, Object> parameters = new HashMap<Integer, Object>();
        CallableStatement statement = (CallableStatement)this.mStatement;
        Object[] keys = this.mOutParams.keySet().toArray();
        int numKeys = keys.length;
        for (int i = 0; i < numKeys; ++i) {
            Integer position = (Integer)keys[i];
            parameters.put(position, statement.getObject(position));
        }
        return parameters;
    }

    private void registerOutParameters() throws SQLException {
        Object[] positions = this.mOutParams.keySet().toArray();
        int numPositions = positions.length;
        for (int i = 0; i < numPositions; ++i) {
            ((CallableStatement)this.mStatement).registerOutParameter((int)((Integer)positions[i]), (int)((Integer)this.mOutParams.get(positions[i])));
        }
    }
}

