/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.sql.parameters;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import uk.org.ogsadai.activity.ActivityContext;
import uk.org.ogsadai.activity.sql.parameters.ParameterAccessException;
import uk.org.ogsadai.activity.sql.parameters.ParameterInput;
import uk.org.ogsadai.activity.sql.parameters.ParameterSetupException;

public class ResultSetInput
implements ParameterInput {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private ResultSet mResultSet;
    private int mCurrentColumn;
    private int mNumColumns;
    private boolean mProcessing = true;
    private int mPosition;

    public ResultSetInput(ResultSet resultSet, int numCols) {
        this.mResultSet = resultSet;
        this.mNumColumns = numCols;
        this.mCurrentColumn = this.mNumColumns + 1;
    }

    public void initialise(int position, ActivityContext context) throws ParameterSetupException {
        this.mPosition = position;
    }

    public Object getNextObject() throws NoSuchElementException, ParameterAccessException {
        if (!this.mProcessing) {
            throw new NoSuchElementException();
        }
        Object block = null;
        try {
            if (this.mCurrentColumn > this.mNumColumns) {
                this.mCurrentColumn = 1;
                if (!this.mResultSet.next()) {
                    this.mProcessing = false;
                    throw new NoSuchElementException();
                }
            }
            block = this.mResultSet.getObject(this.mCurrentColumn);
            ++this.mCurrentColumn;
        }
        catch (SQLException e) {
            throw new ParameterAccessException(this.mPosition, e);
        }
        return block;
    }

    public boolean isDone() {
        return !this.mProcessing;
    }
}

