/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.sql.parameters;

import java.util.NoSuchElementException;
import uk.org.ogsadai.activity.ActivityContext;
import uk.org.ogsadai.activity.sql.parameters.MissingParametersException;
import uk.org.ogsadai.activity.sql.parameters.ParameterAccessException;
import uk.org.ogsadai.activity.sql.parameters.ParameterInput;
import uk.org.ogsadai.activity.sql.parameters.ParameterSetupException;
import uk.org.ogsadai.activity.sql.parameters.ValueInput;

public class ParameterList {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private ParameterInput[] mParameters;
    private int mNumStreams;
    private int mClosedStreams;
    private boolean mFinishedProcessing = false;

    public ParameterList(int length) {
        this.mParameters = new ParameterInput[length + 1];
    }

    public void initialise(ActivityContext context) throws MissingParametersException, ParameterSetupException {
        int numParameters = this.mParameters.length;
        for (int i = 1; i < numParameters; ++i) {
            if (this.mParameters[i] != null) {
                this.mParameters[i].initialise(i, context);
                if (this.mParameters[i] instanceof ValueInput) continue;
                ++this.mNumStreams;
                continue;
            }
            throw new MissingParametersException(i);
        }
    }

    public boolean allStreamsClosed() throws MissingParametersException {
        if (this.mFinishedProcessing) {
            return true;
        }
        if (this.mNumStreams == 0) {
            this.mFinishedProcessing = true;
            return false;
        }
        if (this.mClosedStreams == 0) {
            return false;
        }
        if (this.mNumStreams == this.mClosedStreams) {
            this.mFinishedProcessing = true;
            return true;
        }
        int numParameters = this.mParameters.length;
        for (int i = 0; i < numParameters; ++i) {
            ParameterInput parameter = this.mParameters[i];
            if (parameter != null && (parameter instanceof ValueInput || parameter.isDone())) continue;
            throw new MissingParametersException(i);
        }
        return true;
    }

    public ParameterInput getParameter(int i) {
        return this.mParameters[i];
    }

    public Object getParameterObject(int i) throws ParameterAccessException {
        Object obj = null;
        try {
            obj = this.mParameters[i].getNextObject();
        }
        catch (NoSuchElementException e) {
            obj = null;
            ++this.mClosedStreams;
        }
        return obj;
    }

    public void setParameter(int i, ParameterInput parameter) {
        this.mParameters[i] = parameter;
    }

    public int getLength() {
        return this.mParameters.length;
    }

    public void countNumStreams() {
        this.mNumStreams = 0;
        for (int i = 1; i < this.mParameters.length; ++i) {
            if (this.mParameters[i] instanceof ValueInput) continue;
            ++this.mNumStreams;
        }
    }
}

