/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.sql;

import java.sql.Connection;
import java.sql.SQLException;
import org.w3c.dom.Element;
import uk.org.ogsadai.activity.ActivityAuthorizationException;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.sql.AbstractParameterisedSQLActivity;
import uk.org.ogsadai.activity.sql.parameters.MissingParametersException;
import uk.org.ogsadai.activity.sql.parameters.ParameterAccessException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.dataresource.JDBCConnectionUseException;
import uk.org.ogsadai.exception.AuthorizationExecutionException;
import uk.org.ogsadai.exception.DAIAuthorizationException;

public class SQLUpdateStatementActivity
extends AbstractParameterisedSQLActivity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)SQLUpdateStatementActivity.class);
    private Connection mConnection;
    private int mTotalUpdateCount = 0;
    public static final String UPDATE_COUNT_PREFIX = "<resultStream updateCount=\"";
    public static final String UPDATE_COUNT_POSTFIX = "\"/>";

    public SQLUpdateStatementActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        super.parseExpression("expression", element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "expression"));
        super.parseSQLParameters(element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "sqlParameter"));
        super.parseResultStream("resultStream", element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "resultStream"));
        this.mStatement.setExpression(this.mExpression);
        this.mStatement.setParameters(this.mParameters);
        super.initialiseInputStreamNames();
    }

    protected void processFirst() {
        try {
            this.mConnection = this.mDataResource.getJDBCConnection(this.mCredentials);
        }
        catch (JDBCConnectionUseException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        catch (DAIAuthorizationException e) {
            this.setError(new ActivitySpecificationException(this.getName(), (Throwable)new ActivityAuthorizationException(this.getName(), (Throwable)e)));
            return;
        }
        catch (AuthorizationExecutionException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        catch (Exception e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        this.mStatement.setConnection(this.mConnection);
        try {
            this.mStatement.initialise();
        }
        catch (SQLException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
    }

    protected void processBlock() {
        try {
            int updateCount = this.mStatement.executeUpdate();
            if (updateCount == -1) {
                String block = UPDATE_COUNT_PREFIX + this.mTotalUpdateCount + UPDATE_COUNT_POSTFIX;
                this.mOutput.put((Object)block);
                this.cleanUp();
                this.setCompleted();
            } else {
                this.mTotalUpdateCount += updateCount;
            }
        }
        catch (SQLException e) {
            this.setError(new ActivitySpecificationException(this.getName(), (Throwable)e));
        }
        catch (MissingParametersException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)((Object)e)));
        }
        catch (ParameterAccessException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)((Object)e)));
        }
    }

    protected void cleanUp() {
        try {
            if (this.mStatement != null) {
                this.mStatement.close();
                this.mStatement = null;
            }
        }
        catch (SQLException e) {
            LOG.warn((Throwable)new ActivityExecutionException(this.getName(), (Throwable)e));
        }
        if (this.mOutput != null) {
            this.mOutput.close();
            this.mOutput = null;
        }
        if (this.mConnection != null) {
            try {
                this.mDataResource.releaseJDBCConnection(this.mConnection);
            }
            catch (JDBCConnectionUseException e) {
                this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            }
            this.mConnection = null;
        }
    }
}

