/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.ActivityAuthorizationException;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.sql.AbstractParameterisedSQLActivity;
import uk.org.ogsadai.activity.sql.parameters.MissingParametersException;
import uk.org.ogsadai.activity.sql.parameters.ParameterAccessException;
import uk.org.ogsadai.activity.sql.parameters.ParameterList;
import uk.org.ogsadai.activity.sql.statement.CallableSQLStatement;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.dataresource.JDBCConnectionUseException;
import uk.org.ogsadai.engine.EngineConstants;
import uk.org.ogsadai.exception.AuthorizationExecutionException;
import uk.org.ogsadai.exception.DAIAuthorizationException;
import uk.org.ogsadai.exception.DAINumberFormatException;

public class SQLStoredProcedureActivity
extends AbstractParameterisedSQLActivity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)SQLStoredProcedureActivity.class);
    private Connection mConnection;
    private boolean mFinishedProcessing;
    private boolean mGetMoreResults = true;
    private boolean mIsResultSet = false;

    public SQLStoredProcedureActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        super.parseExpression("storedProcedureName", element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "storedProcedureName"));
        super.parseSQLParameters(element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "sqlParameter"));
        this.mStatement = new CallableSQLStatement();
        NodeList outputResultSetNL = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "resultStream");
        String resultSetStream = this.getStream(outputResultSetNL);
        this.mInternalOutputs = new String[]{resultSetStream};
        NodeList outParametersNL = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "sqlOutParameter");
        this.parseOutParameters(outParametersNL);
        if (this.mParameters != null) {
            this.mStatement.setParameters(this.mParameters);
        } else {
            this.mParameters = new ParameterList(0);
            this.mStatement.setParameters(this.mParameters);
        }
        this.mStatement.setExpression(this.getExpression(this.mParameters.getLength() - 1 + outParametersNL.getLength()));
        super.initialiseInputStreamNames();
    }

    protected void processFirst() {
        try {
            this.mConnection = this.mDataResource.getJDBCConnection(this.mCredentials);
        }
        catch (JDBCConnectionUseException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        catch (DAIAuthorizationException e) {
            this.setError(new ActivitySpecificationException(this.getName(), (Throwable)new ActivityAuthorizationException(this.getName(), (Throwable)e)));
            return;
        }
        catch (AuthorizationExecutionException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        catch (Exception e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        this.mStatement.setConnection(this.mConnection);
        this.mFinishedProcessing = false;
        try {
            this.mStatement.initialise();
        }
        catch (SQLException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
    }

    protected void processBlock() {
        if (this.mFinishedProcessing) {
            this.mOutput.put((Object)EngineConstants.NO_MORE_DATA);
            this.cleanUp();
            this.setCompleted();
            return;
        }
        try {
            CallableSQLStatement statement = (CallableSQLStatement)this.mStatement;
            if (this.mGetMoreResults) {
                this.mIsResultSet = statement.getMoreResults();
                Map outparams = statement.getOutParameters();
                if (outparams != null) {
                    this.mOutput.put((Object)outparams);
                    this.mGetMoreResults = false;
                    return;
                }
            }
            this.mGetMoreResults = true;
            if (this.mIsResultSet) {
                ResultSet result = statement.getNextResultSet();
                if (result != null) {
                    this.mOutput.put((Object)result);
                    return;
                }
            } else {
                int count = statement.getNextUpdateCount();
                if (count != -1) {
                    this.mOutput.put((Object)("<resultStream updateCount=\"" + count + "\"/>"));
                    return;
                }
            }
            this.mFinishedProcessing = true;
        }
        catch (SQLException e) {
            this.setError(new ActivitySpecificationException(this.getName(), (Throwable)e));
            return;
        }
        catch (MissingParametersException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)((Object)e)));
            return;
        }
        catch (ParameterAccessException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)((Object)e)));
            return;
        }
        catch (Throwable e) {
            this.setError(new ActivityExecutionException(this.getName(), e));
        }
    }

    protected void cleanUp() {
        try {
            if (this.mStatement != null) {
                this.mStatement.close();
                this.mStatement = null;
            }
        }
        catch (SQLException e) {
            LOG.warn((Throwable)new ActivityExecutionException(this.getName(), (Throwable)e));
        }
        this.mOutput.close();
        if (this.mConnection != null) {
            try {
                this.mDataResource.releaseJDBCConnection(this.mConnection);
            }
            catch (JDBCConnectionUseException e) {
                this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            }
            this.mConnection = null;
        }
    }

    private String getExpression(int numParameters) {
        StringBuffer expression = new StringBuffer();
        expression.append("{ call " + this.mExpression + "(");
        if (numParameters != 0) {
            for (int i = 0; i < numParameters - 1; ++i) {
                expression.append("?,");
            }
            expression.append("?");
        }
        expression.append(") }");
        return expression.toString();
    }

    private String getStream(NodeList nodelist) {
        String resultStreamName = null;
        if (nodelist.getLength() != 0) {
            Node resultStreamNode = nodelist.item(0);
            resultStreamName = resultStreamNode.getAttributes().getNamedItem("name").getNodeValue();
        }
        return resultStreamName;
    }

    private void parseOutParameters(NodeList nodelist) throws ActivitySpecificationException {
        int numNodes = nodelist.getLength();
        for (int i = 0; i < numNodes; ++i) {
            Element parameter = (Element)nodelist.item(i);
            String posString = parameter.getAttribute("position");
            int position = 0;
            try {
                position = Integer.parseInt(posString);
            }
            catch (NumberFormatException e) {
                throw new ActivitySpecificationException(this.getName(), "sqlOutParameter.position", (Throwable)new DAINumberFormatException(posString));
            }
            String typeString = parameter.getAttribute("type");
            int type = 0;
            try {
                type = Integer.parseInt(typeString);
            }
            catch (NumberFormatException e) {
                throw new ActivitySpecificationException(this.getName(), "sqlOutParameter.type", (Throwable)new DAINumberFormatException(typeString));
            }
            ((CallableSQLStatement)this.mStatement).registerOutParameter(position, type);
        }
    }
}

