/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.Base64Reader;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.converters.resultset.ResultSetConverter;
import uk.org.ogsadai.converters.resultset.ResultSetHandler;
import uk.org.ogsadai.converters.resultset.ResultSetHandlerException;
import uk.org.ogsadai.converters.resultset.webrowset.WebRowSetResultSetHandler;
import uk.org.ogsadai.engine.EngineConstants;
import uk.org.ogsadai.exception.DAIIOException;

public class SQLResultsToXMLActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    public static final String RESULT_SET_ELEMENT = "resultSet";
    public static final String WEBROWSET_ELEMENT = "webRowSet";
    public static final String FROM_ATTRIBUTE = "from";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String NULL_DATA_TAG = "<null/>";
    private String mInputName;
    private BlockReader mInput;
    private String mOutputName;
    private BlockWriter mOutput;
    private ResultSetConverter mWebRowSetConvertor;

    public SQLResultsToXMLActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        NodeList nodelist = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", RESULT_SET_ELEMENT);
        if (nodelist == null || nodelist.getLength() == 0) {
            throw new ActivitySpecificationException(this.getName(), RESULT_SET_ELEMENT);
        }
        String inputName = ((Element)nodelist.item(0)).getAttribute(FROM_ATTRIBUTE);
        this.mInternalInputs = new String[]{inputName};
        nodelist = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", WEBROWSET_ELEMENT);
        if (nodelist == null || nodelist.getLength() == 0) {
            throw new ActivitySpecificationException(this.getName(), WEBROWSET_ELEMENT);
        }
        String outputName = ((Element)nodelist.item(0)).getAttribute(NAME_ATTRIBUTE);
        this.mInternalOutputs = new String[]{outputName};
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    protected void processBlock() {
        try {
            if (this.mWebRowSetConvertor != null && this.mWebRowSetConvertor.hasNext()) {
                String rowsetBlock = new String(this.mWebRowSetConvertor.next());
                this.mOutput.put((Object)rowsetBlock);
            } else {
                this.mWebRowSetConvertor = null;
                if (this.mInput.hasNext()) {
                    Object block = this.mInput.next();
                    if (block.equals(EngineConstants.NO_MORE_DATA)) {
                        this.setCompleted();
                    } else if (block instanceof String) {
                        this.mOutput.put(block);
                    } else if (block instanceof Map) {
                        String xml = this.getOutParametersAsXML((Map)block);
                        this.mOutput.put((Object)xml);
                    } else {
                        ResultSet resultSet = (ResultSet)block;
                        this.mWebRowSetConvertor = new ResultSetConverter(resultSet, (ResultSetHandler)new WebRowSetResultSetHandler(resultSet));
                    }
                } else {
                    this.setCompleted();
                }
            }
        }
        catch (ResultSetHandlerException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
        }
        catch (SQLException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
        }
        catch (IOException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)new DAIIOException(e)));
        }
    }

    private String getOutParametersAsXML(Map params) throws SQLException, IOException {
        StringBuffer sb = new StringBuffer();
        Integer[] positions = params.keySet().toArray(new Integer[params.size()]);
        int numPositions = positions.length;
        for (int i = 0; i < numPositions; ++i) {
            sb.append("<outputParameter position=\"");
            sb.append(positions[i]);
            sb.append("\">");
            Object obj = params.get(positions[i]);
            sb.append(this.getAsString(obj));
            sb.append("</outputParameter>\n");
        }
        return sb.toString();
    }

    private String getAsString(Object obj) throws SQLException, IOException {
        String result = "";
        if (obj == null) {
            result = NULL_DATA_TAG;
        } else if (obj instanceof Blob) {
            Blob blob = (Blob)obj;
            InputStream binaryStream = blob.getBinaryStream();
            if (binaryStream != null) {
                Base64Reader reader = new Base64Reader(binaryStream);
                String encodedString = reader.readAll();
                reader.close();
                if (encodedString.length() > 0) {
                    result = encodedString;
                }
                encodedString = null;
                reader = null;
                binaryStream = null;
            }
        } else if (obj instanceof Clob) {
            Reader reader = ((Clob)obj).getCharacterStream();
            if (reader != null) {
                StringBuffer sb = new StringBuffer();
                char[] buf = new char[4096];
                while (reader.read(buf) > -1) {
                    sb.append(buf);
                }
                result = sb.toString();
            }
        } else {
            result = obj instanceof Time ? Long.toString(((Time)obj).getTime()) : (obj instanceof Date ? Long.toString(((Date)obj).getTime()) : this.replaceSpecialCharacters(obj.toString()));
        }
        return result;
    }

    protected String replaceSpecialCharacters(String input) {
        input = input.replaceAll("&", "&amp;");
        input = input.replaceAll(">", "&gt;");
        input = input.replaceAll("<", "&lt;");
        input = input.replaceAll("\"", "&quot;");
        input = input.replaceAll("'", "&apos;");
        return input;
    }
}

