/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.sql;

import java.sql.ResultSet;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.converters.csv.CSVConfigurationException;
import uk.org.ogsadai.converters.csv.CSVConfigurator;
import uk.org.ogsadai.converters.resultset.ResultSetConverter;
import uk.org.ogsadai.converters.resultset.ResultSetHandler;
import uk.org.ogsadai.converters.resultset.ResultSetHandlerException;
import uk.org.ogsadai.converters.resultset.csv.CSVResultSetHandler;
import uk.org.ogsadai.engine.EngineConstants;

public class SQLResultsToCSVActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)SQLResultsToCSVActivity.class);
    public static final String RESULT_SET_ELEMENT = "resultSet";
    public static final String CSV_ELEMENT = "csvOutput";
    public static final String FROM_ATTRIBUTE = "from";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String DELIMITER_ELEMENT = "delimiter";
    public static final String LINE_BREAK_ELEMENT = "lineBreak";
    public static final String NULL_DATA_STR_ELEMENT = "nullDataStr";
    public static final String INCLUDE_HEADER_ELEMENT = "includeHeader";
    public static final String ESCAPE_FIELDS_ELEMENT = "escapeFields";
    private String mInputName;
    private BlockReader mInput;
    private String mOutputName;
    private BlockWriter mOutput;
    private ResultSetConverter mCSVConvertor;
    private CSVConfigurator mConfigurator = new CSVConfigurator();

    public SQLResultsToCSVActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        NodeList nodelist = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", RESULT_SET_ELEMENT);
        if (nodelist == null || nodelist.getLength() == 0) {
            throw new ActivitySpecificationException(this.getName(), RESULT_SET_ELEMENT);
        }
        String inputName = ((Element)nodelist.item(0)).getAttribute(FROM_ATTRIBUTE);
        this.mInternalInputs = new String[]{inputName};
        nodelist = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", CSV_ELEMENT);
        if (nodelist == null || nodelist.getLength() == 0) {
            throw new ActivitySpecificationException(this.getName(), CSV_ELEMENT);
        }
        String outputName = ((Element)nodelist.item(0)).getAttribute(NAME_ATTRIBUTE);
        this.mInternalOutputs = new String[]{outputName};
        String currentElt = "";
        try {
            String value;
            currentElt = DELIMITER_ELEMENT;
            nodelist = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", DELIMITER_ELEMENT);
            if (nodelist != null) {
                this.mConfigurator.setMDelimiter(((Element)nodelist.item(0)).getAttribute(VALUE_ATTRIBUTE));
            }
            currentElt = LINE_BREAK_ELEMENT;
            nodelist = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", LINE_BREAK_ELEMENT);
            if (nodelist != null) {
                this.mConfigurator.setMLineBreak(((Element)nodelist.item(0)).getAttribute(VALUE_ATTRIBUTE));
            }
            currentElt = NULL_DATA_STR_ELEMENT;
            nodelist = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", NULL_DATA_STR_ELEMENT);
            if (nodelist != null) {
                this.mConfigurator.setMNullDataStr(((Element)nodelist.item(0)).getAttribute(VALUE_ATTRIBUTE));
            }
            currentElt = INCLUDE_HEADER_ELEMENT;
            nodelist = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", INCLUDE_HEADER_ELEMENT);
            if (nodelist != null) {
                value = ((Element)nodelist.item(0)).getAttribute(VALUE_ATTRIBUTE);
                if (value.equals("true")) {
                    this.mConfigurator.setMIncludeHeader(true);
                } else {
                    this.mConfigurator.setMIncludeHeader(false);
                }
            }
            currentElt = ESCAPE_FIELDS_ELEMENT;
            nodelist = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", ESCAPE_FIELDS_ELEMENT);
            if (nodelist != null) {
                value = ((Element)nodelist.item(0)).getAttribute(VALUE_ATTRIBUTE);
                if (value.equals("true")) {
                    this.mConfigurator.setMEscapeFields(true);
                } else {
                    this.mConfigurator.setMEscapeFields(false);
                }
            }
        }
        catch (CSVConfigurationException e) {
            throw new ActivitySpecificationException(this.getName(), currentElt, (Throwable)e);
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    protected void processBlock() {
        try {
            if (this.mCSVConvertor != null && this.mCSVConvertor.hasNext()) {
                String rowsetBlock = new String(this.mCSVConvertor.next());
                this.mOutput.put((Object)rowsetBlock);
            } else {
                this.mCSVConvertor = null;
                if (this.mInput.hasNext()) {
                    Object block = this.mInput.next();
                    if (block.equals(EngineConstants.NO_MORE_DATA)) {
                        this.setCompleted();
                    } else if (block instanceof String) {
                        this.mOutput.put(block);
                    } else if (!(block instanceof Map)) {
                        ResultSet resultSet = (ResultSet)block;
                        this.mCSVConvertor = new ResultSetConverter(resultSet, (ResultSetHandler)new CSVResultSetHandler(resultSet, this.mConfigurator));
                    }
                } else {
                    this.setCompleted();
                }
            }
        }
        catch (ResultSetHandlerException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
        }
    }
}

