/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.sql;

import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.UnsupportedBlockException;
import uk.org.ogsadai.common.msgs.DAILogger;

public class SQLResultToBytesActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)SQLResultToBytesActivity.class);
    public static final String RESULT_SET_ELEMENT = "resultSet";
    public static final String OUTPUT_STREAM_ELEMENT = "outputStream";
    public static final String COLUMN_INDEX_ELEMENT = "columnIndex";
    public static final String BLOCK_SIZE_ELEMENT = "blockSize";
    public static final String FROM_ATTRIBUTE = "from";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final int DEFAULT_BLOCK_SIZE = 1024;
    protected String mInputStreamName;
    protected BlockReader mInput;
    protected String mOutputStreamName;
    protected BlockWriter mOutput;
    protected InputStream mBinaryInputStream = null;
    protected int mColumnIndex;
    protected int mBlockSize;

    public SQLResultToBytesActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        NodeList nodelist = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", RESULT_SET_ELEMENT);
        if (nodelist == null || nodelist.getLength() == 0) {
            throw new ActivitySpecificationException(this.getName(), RESULT_SET_ELEMENT);
        }
        this.mInputStreamName = ((Element)nodelist.item(0)).getAttribute(FROM_ATTRIBUTE);
        this.mInternalInputs = new String[]{this.mInputStreamName};
        nodelist = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", OUTPUT_STREAM_ELEMENT);
        if (nodelist == null || nodelist.getLength() == 0) {
            throw new ActivitySpecificationException(this.getName(), OUTPUT_STREAM_ELEMENT);
        }
        this.mOutputStreamName = ((Element)nodelist.item(0)).getAttribute(NAME_ATTRIBUTE);
        this.mInternalOutputs = new String[]{this.mOutputStreamName};
        nodelist = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", COLUMN_INDEX_ELEMENT);
        if (nodelist == null || nodelist.getLength() == 0) {
            throw new ActivitySpecificationException(this.getName(), COLUMN_INDEX_ELEMENT);
        }
        this.mColumnIndex = Integer.parseInt(((Element)nodelist.item(0)).getAttribute(VALUE_ATTRIBUTE));
        this.mBlockSize = 1024;
        nodelist = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", BLOCK_SIZE_ELEMENT);
        if (nodelist != null && nodelist.getLength() > 0) {
            this.mBlockSize = Integer.parseInt(((Element)nodelist.item(0)).getAttribute(VALUE_ATTRIBUTE));
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public String getInputStreamName() {
        return this.mInputStreamName;
    }

    public String getOutputStreamName() {
        return this.mOutputStreamName;
    }

    public int getColumnIndex() {
        return this.mColumnIndex;
    }

    public int getBlockSize() {
        return this.mBlockSize;
    }

    protected void processBlock() {
        try {
            ResultSet resultSet;
            if (this.mBinaryInputStream == null && (resultSet = this.getResultSet(this.mInput)) != null && resultSet.next()) {
                this.mBinaryInputStream = resultSet.getBinaryStream(this.mColumnIndex);
            }
            if (this.mBinaryInputStream != null) {
                byte[] bytes = this.readBytesFromInputStream(this.mBinaryInputStream, this.mBlockSize);
                if (bytes.length < this.mBlockSize) {
                    this.mBinaryInputStream.close();
                    this.mBinaryInputStream = null;
                }
                if (bytes.length > 0) {
                    this.mOutput.put((Object)bytes);
                }
            }
        }
        catch (SQLException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
        }
        catch (IOException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
        }
    }

    protected byte[] readBytesFromInputStream(InputStream is, int blockSize) throws IOException {
        int numBytes;
        byte[] bytes = new byte[blockSize];
        int bytesInArray = 0;
        do {
            int desiredBytes;
            if ((numBytes = is.read(bytes, bytesInArray, desiredBytes = blockSize - bytesInArray)) != -1) continue;
            byte[] smallerBytes = new byte[bytesInArray];
            System.arraycopy(bytes, 0, smallerBytes, 0, bytesInArray);
            return smallerBytes;
        } while (numBytes <= 0 || (bytesInArray += numBytes) != blockSize);
        return bytes;
    }

    protected ResultSet getResultSet(BlockReader inputReader) {
        ResultSet result = null;
        if (inputReader.hasNext()) {
            Object block = inputReader.next();
            if (block instanceof ResultSet) {
                result = (ResultSet)block;
            } else {
                this.setError(new ActivitySpecificationException(this.getName(), (Throwable)new UnsupportedBlockException(block.getClass().getName())));
            }
        } else {
            this.setCompleted();
        }
        return result;
    }
}

