/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.sql;

import java.util.TimerTask;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.sql.CallDataService;
import uk.org.ogsadai.activity.sql.DataServiceTimeout;
import uk.org.ogsadai.activity.sql.SQLQueryMultipleActivity;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.dataresource.config.DataServiceInfo;
import uk.org.ogsadai.exception.DAINumberFormatException;

public class SQLResilientQueryActivity
extends SQLQueryMultipleActivity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)SQLResilientQueryActivity.class);
    private Element mActivityElement;
    public static final String ACTIVITY_OUTPUT = "sqlResilientOutput";
    public static final String SQL_STATEMENT = "sqlStatement";
    public static final String TIMEOUT = "timeout";

    public SQLResilientQueryActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        this.mActivityElement = element;
        String outputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", ACTIVITY_OUTPUT).item(0)).getAttribute("name");
        this.mInternalOutputs = new String[]{outputName};
        this.mSqlStatement = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", SQL_STATEMENT).item(0)).getAttribute("value");
        NodeList timeout = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", TIMEOUT);
        if (timeout.getLength() > 0) {
            String timeoutString = timeout.item(0).getFirstChild().getNodeValue();
            try {
                this.mClientTimeout = Long.parseLong(timeoutString);
            }
            catch (NumberFormatException e) {
                throw new ActivitySpecificationException(this.getName(), TIMEOUT, (Throwable)new DAINumberFormatException(timeoutString));
            }
        }
    }

    public void processBlock() {
        int i;
        int numDS = this.mMultipleDS.length;
        String result = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Start to process " + numDS + " data services in SQLResilientQueryActivity.");
        }
        for (i = 0; i < numDS; ++i) {
            this.mMultipleDS[i].setLastResponse("N/A");
        }
        for (i = 0; i < numDS; ++i) {
            long maximum;
            DataServiceInfo ds = this.mMultipleDS[i];
            long timeout = this.mClientTimeout <= -1L ? ds.getDefaultTimeOut() : (this.mClientTimeout < (maximum = ds.getMaximumTimeOut()) ? this.mClientTimeout : maximum);
            try {
                CallDataService thread = new CallDataService(this.mActivityElement, ds, this.mSqlStatement);
                Thread dataThread = new Thread(thread);
                dataThread.start();
                DataServiceTimeout timertask = new DataServiceTimeout(this);
                if (timeout > 0L && this.mTimer != null) {
                    this.mTimer.schedule((TimerTask)timertask, timeout);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Timer set for service - " + ds.getDsDescription());
                        LOG.debug("Timer set for " + timeout + " ms.");
                    }
                }
                this.setTimeout(false);
                while (!this.isTimeout() && dataThread.isAlive()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
                    }
                }
                timertask.cancel();
                if (!this.isTimeout()) {
                    result = thread.getResult();
                    if (result != null) {
                        ds.setLastResponse("Ok");
                    } else {
                        ds.setLastResponse("Error");
                    }
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug("The service \"" + ds.getDsDescription() + "\" responsed in time.");
                    break;
                }
                ds.setLastResponse("Timeout");
                dataThread.interrupt();
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("The service \"" + ds.getDsDescription() + "\" timed out.");
                continue;
            }
            catch (ActivitySpecificationException e) {
                this.setError(e);
                this.mOutput.close();
                continue;
            }
            catch (ActivityCreationException e) {
                this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
                this.mOutput.close();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("all data services processed.");
        }
        this.mOutputString = result == null ? "" : result;
        this.mOutput.put((Object)this.mOutputString);
        this.setCompleted();
        this.cleanUp();
    }
}

