/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.sql;

import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.ActivityAuthorizationException;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.sql.AbstractSQLActivity;
import uk.org.ogsadai.activity.sql.parameters.MissingParametersException;
import uk.org.ogsadai.activity.sql.parameters.ParameterAccessException;
import uk.org.ogsadai.activity.sql.parameters.ParameterList;
import uk.org.ogsadai.activity.sql.parameters.ParameterSetupException;
import uk.org.ogsadai.activity.sql.parameters.ResultSetInput;
import uk.org.ogsadai.activity.sql.statement.ParameterisedSQLStatement;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockReaderReader;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.converters.webrowset.resultset.WebRowSetToResultSet;
import uk.org.ogsadai.dataresource.JDBCConnectionUseException;
import uk.org.ogsadai.exception.AuthorizationExecutionException;
import uk.org.ogsadai.exception.DAIAuthorizationException;

public class SQLBulkLoadRowSetActivity
extends AbstractSQLActivity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)SQLBulkLoadRowSetActivity.class);
    private Connection mConnection;
    public static String LOAD_INTO_TABLE = "loadIntoTable";
    private int mUpdateCount = -1;
    private int mTotalInsertCount = 0;
    private boolean mFinishedProcessing;
    private BlockReader mInput;
    private ParameterList mParameters;
    private String mTableName;
    private boolean mIsTransaction;

    public SQLBulkLoadRowSetActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        super.parseExpression("expression", element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "expression"));
        super.parseResultStream("resultStream", element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "resultStream"));
        this.parseInputStream(element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "webRowSetStream"));
        this.parseTableName(element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", LOAD_INTO_TABLE));
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
        this.mStatement = new ParameterisedSQLStatement();
    }

    protected void processFirst() {
        try {
            this.mConnection = this.mDataResource.getJDBCConnection(this.mCredentials);
        }
        catch (JDBCConnectionUseException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        catch (DAIAuthorizationException e) {
            this.setError(new ActivitySpecificationException(this.getName(), (Throwable)new ActivityAuthorizationException(this.getName(), (Throwable)e)));
            return;
        }
        catch (AuthorizationExecutionException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        catch (Exception e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        ResultSet resultSet = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("About to parse rowset");
            }
            WebRowSetToResultSet converter = new WebRowSetToResultSet((Reader)new BlockReaderReader(this.mInput));
            converter.setResultSetType(1003);
            resultSet = converter.getResultSet();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parsed rowset");
            }
        }
        catch (Exception e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        try {
            if (this.mIsTransaction) {
                this.mConnection.setAutoCommit(false);
            }
            this.mExpression = this.buildExpressionAndParameters(resultSet);
            this.mParameters.initialise(this.mContext);
            this.mStatement.setExpression(this.mExpression);
            this.mStatement.setParameters(this.mParameters);
            this.mStatement.setConnection(this.mConnection);
            this.mStatement.initialise();
            this.mUpdateCount = this.mStatement.executeUpdate();
        }
        catch (SQLException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        catch (MissingParametersException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)((Object)e)));
            return;
        }
        catch (ParameterAccessException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)((Object)e)));
            return;
        }
        catch (ParameterSetupException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)((Object)e)));
            return;
        }
        if (this.mUpdateCount == -1) {
            String output = "<resultStream updateCount=\"" + this.mTotalInsertCount + "\"/>";
            this.mOutput.put((Object)output);
            this.endProcessing();
            this.setCompleted();
        } else {
            this.mTotalInsertCount += this.mUpdateCount;
        }
    }

    protected void processBlock() {
        try {
            this.mUpdateCount = this.mStatement.executeUpdate();
        }
        catch (SQLException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        catch (MissingParametersException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)((Object)e)));
            return;
        }
        catch (ParameterAccessException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)((Object)e)));
            return;
        }
        if (this.mUpdateCount == -1) {
            String output = "<resultStream updateCount=\"" + this.mTotalInsertCount + "\"/>";
            this.mOutput.put((Object)output);
            this.endProcessing();
            this.setCompleted();
            return;
        }
        this.mTotalInsertCount += this.mUpdateCount;
    }

    private void endProcessing() {
        block7: {
            try {
                if (this.mIsTransaction) {
                    this.mConnection.commit();
                }
                if (this.mStatement != null) {
                    this.mStatement.close();
                    this.mStatement = null;
                }
                if (this.mOutput != null) {
                    this.mOutput.close();
                    this.mOutput = null;
                }
                if (this.mConnection == null) break block7;
                try {
                    this.mDataResource.releaseJDBCConnection(this.mConnection);
                }
                catch (JDBCConnectionUseException e) {
                    this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
                }
                this.mConnection = null;
            }
            catch (SQLException e) {
                this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            }
        }
    }

    protected void cleanUp() {
        try {
            if (this.mIsTransaction) {
                this.mConnection.rollback();
                this.mConnection.setAutoCommit(true);
            }
            if (this.mStatement != null) {
                this.mStatement.close();
                this.mStatement = null;
            }
        }
        catch (SQLException e) {
            LOG.warn((Throwable)new ActivityExecutionException(this.getName(), (Throwable)e));
        }
        if (this.mOutput != null) {
            this.mOutput.close();
            this.mOutput = null;
        }
        if (this.mConnection != null) {
            try {
                this.mDataResource.releaseJDBCConnection(this.mConnection);
            }
            catch (JDBCConnectionUseException e) {
                this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            }
            this.mConnection = null;
        }
    }

    private void parseInputStream(NodeList inputNL) throws ActivitySpecificationException {
        String webrowsetStreamName;
        if (inputNL.getLength() != 0) {
            Node webrowsetStreamNode = inputNL.item(0);
            webrowsetStreamName = webrowsetStreamNode.getAttributes().getNamedItem("from").getNodeValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("My input stream is called :" + webrowsetStreamName);
            }
        } else {
            throw new ActivitySpecificationException(this.getName(), "webRowSetStream.from");
        }
        this.mInternalInputs = new String[]{webrowsetStreamName};
    }

    private void parseTableName(NodeList tableList) {
        if (tableList.getLength() != 0) {
            NamedNodeMap tableAttributes = tableList.item(0).getAttributes();
            this.mTableName = tableAttributes.getNamedItem("tableName").getNodeValue();
            Node transAttrib = tableAttributes.getNamedItem("transactionally");
            this.mIsTransaction = transAttrib != null ? new Boolean(transAttrib.getNodeValue()) : true;
        }
    }

    private String buildExpressionAndParameters(ResultSet resultSet) throws SQLException {
        int i;
        ResultSetMetaData metadata = resultSet.getMetaData();
        int numCols = metadata.getColumnCount();
        this.mParameters = new ParameterList(numCols);
        if (this.mTableName == null) {
            this.mTableName = metadata.getTableName(1);
        }
        StringBuffer expression = new StringBuffer("INSERT INTO " + this.mTableName + " (");
        ResultSetInput parameter = new ResultSetInput(resultSet, numCols);
        for (i = 1; i <= numCols; ++i) {
            this.mParameters.setParameter(i, parameter);
            expression.append(metadata.getColumnName(i));
            if (i == numCols) continue;
            expression.append(", ");
        }
        expression.append(") VALUES (");
        for (i = 1; i < numCols; ++i) {
            expression.append("?");
            expression.append(", ");
        }
        expression.append("?)");
        return expression.toString();
    }
}

