/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.sql;

import java.util.TimerTask;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.sql.CallDataService;
import uk.org.ogsadai.activity.sql.DataServiceTimeout;
import uk.org.ogsadai.activity.sql.SQLQueryMultipleActivity;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLDocumentException;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.dataresource.config.DataServiceInfo;
import uk.org.ogsadai.exception.DAINumberFormatException;

public class SQLBagActivity
extends SQLQueryMultipleActivity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)SQLBagActivity.class);
    private Element mActivityElement;
    private boolean mIsError = false;
    private boolean mIsAllNull = true;
    private Throwable mThrowable;
    public static final String ACTIVITY_OUTPUT = "sqlBagOutput";
    public static final String SQL_STATEMENT = "sqlStatement";
    public static final String TIMEOUT = "timeout";

    public SQLBagActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        this.mActivityElement = element;
        String outputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", ACTIVITY_OUTPUT).item(0)).getAttribute("name");
        this.mInternalOutputs = new String[]{outputName};
        this.mSqlStatement = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", SQL_STATEMENT).item(0)).getAttribute("value");
        NodeList timeout = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", TIMEOUT);
        if (timeout.getLength() > 0) {
            String timeoutString = timeout.item(0).getFirstChild().getNodeValue();
            try {
                this.mClientTimeout = Long.parseLong(timeoutString);
            }
            catch (NumberFormatException e) {
                throw new ActivitySpecificationException(this.getName(), TIMEOUT, (Throwable)new DAINumberFormatException(timeoutString));
            }
        }
    }

    public void processBlock() {
        int numDS = this.mMultipleDS.length;
        String[] results = new String[numDS];
        if (LOG.isDebugEnabled()) {
            LOG.debug("Start to process " + numDS + " data services.");
        }
        for (int i = 0; i < numDS; ++i) {
            long maximum;
            DataServiceInfo ds = this.mMultipleDS[i];
            long timeout = this.mClientTimeout <= -1L ? ds.getDefaultTimeOut() : (this.mClientTimeout == 0L ? 0L : (this.mClientTimeout < (maximum = ds.getMaximumTimeOut()) ? this.mClientTimeout : maximum));
            CallDataService thread = null;
            try {
                thread = new CallDataService(this.mActivityElement, ds, this.mSqlStatement);
            }
            catch (ActivitySpecificationException e) {
                this.setError(e);
                this.mOutput.close();
            }
            catch (ActivityCreationException e) {
                this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
                this.mOutput.close();
            }
            Thread dataThread = new Thread(thread);
            dataThread.start();
            DataServiceTimeout timertask = new DataServiceTimeout(this);
            if (timeout > 0L && this.mTimer != null) {
                this.mTimer.schedule((TimerTask)timertask, timeout);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Timer set for service - " + ds.getDsDescription());
                    LOG.debug("Timer set for " + timeout + " ms.");
                }
            }
            this.setTimeout(false);
            while (!this.isTimeout() && dataThread.isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
                }
            }
            timertask.cancel();
            if (!this.isTimeout()) {
                results[i] = thread.getResult();
                if (results[i] != null) {
                    ds.setLastResponse("Ok");
                    this.mIsAllNull = false;
                } else {
                    if (thread.getCause() != null) {
                        this.mIsError = true;
                        this.mThrowable = this.getCause();
                    }
                    ds.setLastResponse("Error");
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("The service \"" + ds.getDsDescription() + "\" responsed in time.");
                continue;
            }
            results[i] = null;
            ds.setLastResponse("Timeout");
            dataThread.interrupt();
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("The service \"" + ds.getDsDescription() + "\" timed out.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("all data services processed.");
        }
        if (this.mIsAllNull && this.mIsError) {
            this.setError(new ActivitySpecificationException(this.getName(), this.mThrowable));
        }
        try {
            this.mOutputString = this.mergeResults(results);
        }
        catch (XMLDocumentException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            this.mOutput.close();
        }
        catch (XMLParseException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            this.mOutput.close();
        }
        if (this.mOutputString == null) {
            this.mOutputString = "";
        }
        this.mOutput.put((Object)this.mOutputString);
        this.setCompleted();
        this.cleanUp();
    }

    private String mergeResults(String[] rowsets) throws XMLDocumentException, XMLParseException {
        int first;
        if (rowsets == null) {
            return null;
        }
        String result = null;
        int numRowsets = rowsets.length;
        for (first = 0; first < numRowsets && rowsets[first] == null; ++first) {
        }
        if (first == numRowsets) {
            return null;
        }
        Document main = XMLUtilities.xmlStringToDOM((String)rowsets[first], (boolean)false);
        Node data = main.getElementsByTagName("data").item(0);
        for (int i = first + 1; i < numRowsets; ++i) {
            if (rowsets[i] == null) continue;
            Document other = XMLUtilities.xmlStringToDOM((String)rowsets[i], (boolean)false);
            NodeList rows = other.getElementsByTagName("currentRow");
            int numRows = rows.getLength();
            for (int j = 0; j < numRows; ++j) {
                Node aRow = main.importNode(rows.item(j), true);
                data.appendChild(aRow);
            }
        }
        result = XMLUtilities.xmlDOMToString((Node)main);
        return result;
    }
}

