/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.exception.DAINumberFormatException;

public class ResultsetProjectionActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)ResultsetProjectionActivity.class);
    private BlockReader mInput;
    private BlockWriter mOutput;
    private String mAttributeName;
    private int mAttributeIndex;
    private boolean isName;

    public ResultsetProjectionActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        String inputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "resultsetInput").item(0)).getAttribute("from");
        String outputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "attributeValuesOutput").item(0)).getAttribute("name");
        this.mInternalInputs = new String[]{inputName};
        this.mInternalOutputs = new String[]{outputName};
        NodeList list = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "attributeName");
        if (list.getLength() > 0) {
            this.mAttributeName = list.item(0).getFirstChild().getNodeValue();
        }
        if ((list = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "attributeIndex")).getLength() > 0) {
            String indexString = null;
            try {
                indexString = list.item(0).getFirstChild().getNodeValue();
                this.mAttributeIndex = Integer.parseInt(indexString);
            }
            catch (NumberFormatException e) {
                throw new ActivitySpecificationException(this.getName(), "attributeIndex", (Throwable)new DAINumberFormatException(indexString));
            }
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
            this.isName = this.mAttributeName != null;
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processBlock() {
        if (this.mInput.hasNext()) {
            try {
                Object block = this.mInput.next();
                if (!(block instanceof ResultSet)) return;
                ResultSet resultSet = (ResultSet)block;
                if (this.isName) {
                    while (resultSet.next()) {
                        this.mOutput.put(resultSet.getObject(this.mAttributeName));
                    }
                    return;
                }
                while (resultSet.next()) {
                    this.mOutput.put(resultSet.getObject(this.mAttributeIndex));
                }
                return;
            }
            catch (SQLException sqle) {
                this.setError(new ActivitySpecificationException(this.getName(), (Throwable)sqle));
                this.mOutput.close();
                return;
            }
        } else {
            this.setCompleted();
        }
    }
}

