/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.sql;

import java.util.ArrayList;
import java.util.HashSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLDocumentException;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class RemoveDuplicatesWebRowSetActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2004";
    private static final DAILogger LOG = DAILogger.getLogger((Class)RemoveDuplicatesWebRowSetActivity.class);
    private BlockReader mInput;
    private BlockWriter mOutput;
    private StringBuffer myBuf;

    public RemoveDuplicatesWebRowSetActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        String inputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "stringsInput").item(0)).getAttribute("from");
        String outputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "uniqueOutput").item(0)).getAttribute("name");
        this.mInternalInputs = new String[]{inputName};
        this.mInternalOutputs = new String[]{outputName};
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        try {
            this.mInput = this.mContext.getInput(this.mInternalInputs[0]);
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
            this.myBuf = new StringBuffer();
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public void processBlock() {
        if (this.mInput.hasNext()) {
            this.myBuf.append(this.mInput.next());
        } else {
            try {
                this.mOutput.put((Object)this.removeDup(this.myBuf.toString()));
            }
            catch (XMLDocumentException e) {
                this.setError(new ActivitySpecificationException(this.getName(), (Throwable)e));
                this.mOutput.close();
            }
            catch (XMLParseException e) {
                this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
                this.mOutput.close();
            }
            this.setCompleted();
        }
    }

    private String removeDup(String inputRowSet) throws XMLDocumentException, XMLParseException {
        if (inputRowSet == null) {
            return null;
        }
        Document dom = XMLUtilities.xmlStringToDOM((String)inputRowSet, (boolean)false);
        Element data = (Element)dom.getElementsByTagName("data").item(0);
        NodeList rows = dom.getElementsByTagName("currentRow");
        HashSet<String> set = new HashSet<String>();
        ArrayList<Integer> toDel = new ArrayList<Integer>();
        StringBuffer values = new StringBuffer();
        int numRows = rows.getLength();
        for (int i = 0; i < numRows; ++i) {
            NodeList columns = ((Element)rows.item(i)).getElementsByTagName("columnValue");
            int numCols = columns.getLength();
            for (int j = 0; j < numCols; ++j) {
                values.append(columns.item(j).getFirstChild().getNodeValue());
            }
            if (!set.add(values.toString())) {
                toDel.add(new Integer(i));
            }
            values.setLength(0);
        }
        int numToDel = toDel.size();
        for (int i = 0; i < numToDel; ++i) {
            data.removeChild(rows.item((Integer)toDel.get(i) - i));
        }
        return XMLUtilities.xmlDOMToString((Node)dom);
    }
}

