/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.sql;

import java.util.NoSuchElementException;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.engine.Pipe;

public class NonBufferingPipe
implements Pipe {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private final Activity mActivity;
    private Object mBuffer = null;
    private boolean mClosed = false;

    public NonBufferingPipe(Activity activity) {
        this.mActivity = activity;
    }

    public boolean hasNext() {
        if (this.mBuffer == null) {
            this.process();
        }
        return this.mBuffer != null;
    }

    public Object next() {
        if (this.hasNext()) {
            Object block = this.mBuffer;
            this.mBuffer = null;
            return block;
        }
        throw new NoSuchElementException("There are no more blocks.");
    }

    public void put(Object block) {
        if (block == null) {
            throw new IllegalArgumentException("block must not be null");
        }
        if (this.mClosed) {
            throw new IllegalStateException("put must not be invoked if the pipe has been closed");
        }
        this.mBuffer = block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() {
        Activity activity = this.mActivity;
        synchronized (activity) {
            while (this.mBuffer == null && this.mActivity.getStatus().isUnfinished()) {
                this.mActivity.process();
            }
        }
    }

    public synchronized void close() {
        this.mClosed = true;
    }

    public synchronized boolean isOpen() {
        return !this.mClosed;
    }
}

