/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.sql;

import java.net.MalformedURLException;
import org.w3c.dom.Element;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.client.toolkit.GenericServiceFetcher;
import uk.org.ogsadai.client.toolkit.Request;
import uk.org.ogsadai.client.toolkit.ResourceID;
import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.SimpleResourceIDImpl;
import uk.org.ogsadai.client.toolkit.activity.ActivityRequest;
import uk.org.ogsadai.client.toolkit.activity.RequestComponent;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLQuery;
import uk.org.ogsadai.client.toolkit.activity.sql.WebRowSet;
import uk.org.ogsadai.client.toolkit.exception.AuthorisationException;
import uk.org.ogsadai.client.toolkit.exception.RequestException;
import uk.org.ogsadai.client.toolkit.exception.ResourceUnknownException;
import uk.org.ogsadai.client.toolkit.exception.ServiceCommsException;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.dataresource.config.DataServiceInfo;
import uk.org.ogsadai.exception.DAIMalformedURLException;

class CallDataService
extends Activity
implements Runnable {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private static final DAILogger LOG = DAILogger.getLogger((Class)CallDataService.class);
    private DataServiceInfo mDataServiceInfo;
    private String mWebRowSet;
    private String mSqlStatement;

    CallDataService(Element element, DataServiceInfo dataServiceInfo, String sqlStatement) throws ActivityCreationException, ActivitySpecificationException {
        super(element);
        this.mDataServiceInfo = dataServiceInfo;
        this.mSqlStatement = sqlStatement;
        this.mWebRowSet = null;
    }

    String getResult() {
        return this.mWebRowSet;
    }

    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Thread CallDataService starts to run for service - " + this.mDataServiceInfo.getDsDescription());
        }
        try {
            DataService service = GenericServiceFetcher.getInstance().getDataService(this.mDataServiceInfo.getDsUrl(), null);
            service.setResourceID((ResourceID)new SimpleResourceIDImpl(this.mDataServiceInfo.getDrId()));
            ActivityRequest request = new ActivityRequest();
            SQLQuery query = new SQLQuery(this.mSqlStatement);
            WebRowSet wrs = new WebRowSet(query.getOutput());
            request.add((RequestComponent)query);
            request.add((RequestComponent)wrs);
            Response response = service.perform((Request)request);
            this.mWebRowSet = wrs.getOutput().getData();
        }
        catch (MalformedURLException e) {
            this.setError(new ActivitySpecificationException(this.getName(), (Throwable)new DAIMalformedURLException(this.mDataServiceInfo.getDsUrl())));
        }
        catch (AuthorisationException e) {
            this.setError(new ActivitySpecificationException(this.getName(), (Throwable)e));
        }
        catch (RequestException e) {
            this.setError(new ActivitySpecificationException(this.getName(), (Throwable)e));
        }
        catch (ServiceCommsException e) {
            this.setError(new ActivitySpecificationException(this.getName(), (Throwable)e));
        }
        catch (ResourceUnknownException e) {
            this.setError(new ActivitySpecificationException(this.getName(), (Throwable)e));
        }
        catch (Exception e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Thread CallDataService ends for service - " + this.mDataServiceInfo.getDsDescription());
        }
    }

    protected void processBlock() {
    }
}

