/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.sql;

import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.sql.NonBufferingPipe;
import uk.org.ogsadai.activity.sql.statement.SQLStatement;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.dataresource.JDBCConnectionProvider;
import uk.org.ogsadai.engine.Pipe;

public abstract class AbstractSQLActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2006. (c) University of Edinburgh 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)AbstractSQLActivity.class);
    protected String mCredentials;
    protected JDBCConnectionProvider mDataResource;
    protected BlockWriter mOutput;
    protected Set mInputStreamNames = new HashSet();
    protected String mExpression;
    protected SQLStatement mStatement;
    public static final String EXPRESSION = "expression";
    public static final String STORED_PROCEDURE = "storedProcedureName";
    public static final String CREATE_DATABASE = "createDatabase";
    public static final String DROP_DATABASE = "dropDatabase";
    public static final String SQL_PARAMETERS = "sqlParameter";
    public static final String SQL_OUT_PARAMETERS = "sqlOutParameter";
    public static final String WEB_ROW_SET_STREAM = "webRowSetStream";
    public static final String RESULT_STREAM = "resultStream";

    public AbstractSQLActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        this.mDataResource = (JDBCConnectionProvider)this.mContext.getDataResourceAccessor();
        this.mCredentials = this.mContext.getSecurityContext().getDN();
        try {
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    protected void parseExpression(String eltName, NodeList list) throws ActivitySpecificationException {
        if (list.getLength() != 0) {
            Node child = list.item(0).getFirstChild();
            if (child == null) {
                throw new ActivitySpecificationException(this.getName(), eltName);
            }
            this.mExpression = child.getNodeValue().trim();
            this.mExpression = this.mExpression.replaceAll("[\n\r\f]", " ");
        }
    }

    protected void parseResultStream(String eltName, NodeList list) throws ActivitySpecificationException {
        String resultStreamName;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entering parseResultStream");
        }
        if (list.getLength() != 0) {
            Node resultStreamNode = list.item(0);
            resultStreamName = resultStreamNode.getAttributes().getNamedItem("name").getNodeValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("resultStream is called :" + resultStreamName);
            }
        } else {
            throw new ActivitySpecificationException(this.getName(), eltName);
        }
        this.mInternalOutputs = new String[]{resultStreamName};
    }

    protected Pipe createOutputPipe(int i) {
        return new NonBufferingPipe(this);
    }
}

