/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.sql;

import java.lang.reflect.Array;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.sql.AbstractSQLActivity;
import uk.org.ogsadai.activity.sql.parameters.MissingParametersException;
import uk.org.ogsadai.activity.sql.parameters.ParameterDuplicationException;
import uk.org.ogsadai.activity.sql.parameters.ParameterList;
import uk.org.ogsadai.activity.sql.parameters.ParameterSetupException;
import uk.org.ogsadai.activity.sql.parameters.StreamInput;
import uk.org.ogsadai.activity.sql.parameters.ValueInput;
import uk.org.ogsadai.activity.sql.statement.ParameterisedSQLStatement;
import uk.org.ogsadai.activity.sql.statement.SimpleSQLStatement;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.exception.DAINumberFormatException;
import uk.org.ogsadai.exception.DAIOutOfBoundsException;

public abstract class AbstractParameterisedSQLActivity
extends AbstractSQLActivity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2006. (c) University of Edinburgh 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)AbstractParameterisedSQLActivity.class);
    protected ParameterList mParameters;

    public AbstractParameterisedSQLActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        try {
            if (this.mParameters != null) {
                this.mParameters.initialise(this.mContext);
            }
        }
        catch (ParameterSetupException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)((Object)e));
        }
        catch (MissingParametersException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)((Object)e));
        }
    }

    protected void parseSQLParameters(NodeList parameterNodes) throws ActivitySpecificationException {
        int numParameters;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entering parseSQLParameters");
        }
        if ((numParameters = parameterNodes.getLength()) == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No SQLParameters found");
                LOG.debug("Exiting parseSQLParameters");
            }
            this.mStatement = new SimpleSQLStatement();
            return;
        }
        this.mStatement = new ParameterisedSQLStatement();
        if (LOG.isDebugEnabled()) {
            LOG.debug(numParameters + " SQLParameters found");
        }
        this.mParameters = new ParameterList(numParameters);
        for (int i = 0; i < numParameters; ++i) {
            Node parameterNode = parameterNodes.item(i);
            String positionString = parameterNode.getAttributes().getNamedItem("position").getNodeValue();
            int position = 0;
            try {
                position = new Integer(positionString);
            }
            catch (NumberFormatException e) {
                throw new ActivitySpecificationException(this.getName(), "sqlParameter.position", (Throwable)new DAINumberFormatException(positionString));
            }
            if (position < 1 || position > numParameters) {
                throw new ActivitySpecificationException(this.getName(), "sqlParameter.position", (Throwable)new DAIOutOfBoundsException(position, 1, numParameters));
            }
            if (this.mParameters.getParameter(position) != null) {
                throw new ActivitySpecificationException(this.getName(), "sqlParameter.position", (Throwable)((Object)new ParameterDuplicationException(position)));
            }
            Node fromNode = parameterNode.getAttributes().getNamedItem("from");
            NodeList valueNodes = parameterNode.getChildNodes();
            if (fromNode != null && valueNodes.getLength() != 0) {
                throw new ActivitySpecificationException(this.getName(), "sqlParameter.position", (Throwable)((Object)new ParameterDuplicationException(position)));
            }
            if (fromNode != null) {
                String from = fromNode.getNodeValue();
                this.mParameters.setParameter(position, new StreamInput(from));
                this.mInputStreamNames.add(from);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Input stream given for parameter at position " + position + " Stream Name :" + from);
                continue;
            }
            if (valueNodes.getLength() > 1 || valueNodes.item(0) == null) {
                throw new ActivitySpecificationException(this.getName(), "sqlParameter." + i);
            }
            String value = valueNodes.item(0).getNodeValue();
            value = value.trim();
            this.mParameters.setParameter(position, new ValueInput(value));
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Value given for parameter at position " + position + " Value :" + value);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exiting parseSQLParameters");
        }
    }

    protected void initialiseInputStreamNames() {
        this.mInternalInputs = new String[this.mInputStreamNames.size()];
        if (this.mInputStreamNames.size() > 0) {
            int j = 0;
            Iterator mIterator = this.mInputStreamNames.iterator();
            while (mIterator.hasNext()) {
                String name = (String)mIterator.next();
                Array.set(this.mInternalInputs, j, name);
                ++j;
            }
        }
    }
}

