/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.resource;

import org.w3c.dom.Element;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.service.resource.factory.DataServiceResourceFactory;

public class RemoveResourceActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private BlockWriter mOutput;
    private String mResourceName;
    private boolean mRemoveConfigurationDir;

    public RemoveResourceActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        String outputName = ((Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "output").item(0)).getAttribute("name");
        this.mInternalOutputs = new String[]{outputName};
        Element configuration = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "resource").item(0);
        this.mResourceName = configuration.getAttribute("name");
        this.mRemoveConfigurationDir = new Boolean(configuration.getAttribute("removeConfiguration"));
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        try {
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    public void processBlock() {
        DataServiceResourceFactory factory = this.mContext.getDataResourceFactory();
        try {
            factory.removeResource(this.mResourceName, this.mRemoveConfigurationDir);
            this.mOutput.put((Object)this.mResourceName);
            this.setCompleted();
        }
        catch (Exception e) {
            ActivitySpecificationException error = new ActivitySpecificationException(this.getName(), (Throwable)e);
            this.setError(error);
        }
    }
}

