/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.relational;

import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityAuthorizationException;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.relational.PhysicalMetaDataToXML;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.NetUtilities;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.dataresource.DataResourceUseException;
import uk.org.ogsadai.dataresource.JDBCConnectionProvider;
import uk.org.ogsadai.dataresource.JDBCConnectionUseException;
import uk.org.ogsadai.exception.AuthorizationExecutionException;
import uk.org.ogsadai.exception.DAIAuthorizationException;
import uk.org.ogsadai.exception.DAIUnknownHostException;

public class SQLServerExtractPhysicalSchemaActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)SQLServerExtractPhysicalSchemaActivity.class);
    private JDBCConnectionProvider mDataResource;
    private Connection mConnection;
    private String mCredentials;
    private BlockWriter mOutput;
    private ResultSet mTableNames;
    private String mTablePattern;

    public SQLServerExtractPhysicalSchemaActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        Element getTables;
        Element output = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "output").item(0);
        String outputName = output.getAttribute("name");
        this.mInternalOutputs = new String[]{outputName};
        NodeList nodelist = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "getTables");
        if (nodelist != null && nodelist.getLength() > 0 && (getTables = (Element)nodelist.item(0)).hasAttribute("name")) {
            this.mTablePattern = getTables.getAttribute("name");
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        this.mDataResource = (JDBCConnectionProvider)this.mContext.getDataResourceAccessor();
        this.mCredentials = this.mContext.getSecurityContext().getDN();
        try {
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    protected void processFirst() {
        try {
            this.mConnection = this.mDataResource.getJDBCConnection(this.mCredentials);
        }
        catch (JDBCConnectionUseException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        catch (DAIAuthorizationException e) {
            this.setError(new ActivitySpecificationException(this.getName(), (Throwable)new ActivityAuthorizationException(this.getName(), (Throwable)e)));
            return;
        }
        catch (AuthorizationExecutionException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        catch (DataResourceUseException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        catch (Exception e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        try {
            StringBuffer schema = new StringBuffer();
            PhysicalMetaDataToXML.writeHeader(schema, NetUtilities.getMachineIPAddress(), this.getDatabaseName(this.mConnection), null, null);
            this.mOutput.put((Object)schema.toString());
            DatabaseMetaData metadata = this.mConnection.getMetaData();
            String catalog = this.mConnection.getCatalog();
            String table = this.mTablePattern;
            if (this.mTablePattern == null) {
                table = "%";
            }
            this.mTableNames = metadata.getTables(catalog, null, table, new String[]{"TABLE"});
        }
        catch (SQLException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        catch (UnknownHostException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)new DAIUnknownHostException(e)));
            return;
        }
    }

    protected void processBlock() {
        StringBuffer schema = new StringBuffer();
        try {
            if (this.mTableNames.next()) {
                String name = this.mTableNames.getString("TABLE_NAME");
                Statement statement = this.mConnection.createStatement();
                String query = "exec sp_spaceused " + name;
                ResultSet tableinfo = statement.executeQuery(query);
                tableinfo.next();
                PhysicalMetaDataToXML.writeTable(schema, name, null, String.valueOf(tableinfo.getLong("rows")), null, this.convertToBytes(tableinfo.getString("data")), this.convertToBytes(tableinfo.getString("index_size")));
                this.mOutput.put((Object)schema.toString());
            } else {
                PhysicalMetaDataToXML.writeFooter(schema);
                this.mOutput.put((Object)schema.toString());
                this.mOutput.close();
                this.mOutput = null;
                this.mDataResource.releaseJDBCConnection(this.mConnection);
                this.mConnection = null;
                this.setCompleted();
            }
        }
        catch (SQLException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
        catch (JDBCConnectionUseException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)e));
            return;
        }
    }

    protected void cleanUp() {
        if (this.mConnection != null) {
            try {
                this.mDataResource.releaseJDBCConnection(this.mConnection);
                this.mConnection = null;
            }
            catch (JDBCConnectionUseException e) {
                LOG.warn((Throwable)new ActivityExecutionException(this.getName(), (Throwable)e));
                return;
            }
        }
        if (this.mOutput != null) {
            this.mOutput.close();
        }
    }

    private String getDatabaseName(Connection connection) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        String dburlstr = metadata.getURL();
        int start = dburlstr.indexOf(";DATABASENAME=") + ";DATABASENAME=".length();
        int end = dburlstr.indexOf(";", start);
        String dbname = dburlstr = dburlstr.substring(start, end);
        return dbname;
    }

    private String convertToBytes(String kb) {
        if (kb.endsWith(" KB")) {
            long size = Long.parseLong(kb.substring(0, kb.indexOf(" KB")));
            return String.valueOf(size * 1024L);
        }
        return kb;
    }
}

