/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.relational;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.ActivityConfiguration;
import uk.org.ogsadai.activity.ActivityConfigurationException;
import uk.org.ogsadai.common.xml.XMLMissingElementException;

public class PhysicalSchemaFileActivityConfiguration
implements ActivityConfiguration {
    private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2006";
    public static final String ATTR_ROW_COUNT = "rowCount";
    public static final String ATTR_ROW_FORMAT = "rowFormat";
    public static final String ATTR_AVG_ROW_SIZE = "avgRowLength";
    public static final String ATTR_DATA_LENGTH = "dataLength";
    public static final String ATTR_INDEX_LENGTH = "indexLength";
    public static final String ATTR_NAME = "name";
    private Set mTableNames = new HashSet();
    private Map mRowCounts = new HashMap();
    private Map mRowFormat = new HashMap();
    private Map mDataLength = new HashMap();
    private Map mIndexLength = new HashMap();
    private Map mAvgRowLength = new HashMap();
    private String mMaxJoinSize;
    private String mJoinBufferSize;
    private String mDatabase;
    private String mName;

    public PhysicalSchemaFileActivityConfiguration(String name) {
        this.mName = name;
    }

    public void initialise(Document document) throws ActivityConfigurationException {
        NodeList database = document.getElementsByTagName("database");
        if (database != null && database.getLength() > 0) {
            Element db = (Element)database.item(0);
            this.mDatabase = db.getAttribute(ATTR_NAME);
            if (db.hasAttribute("maxJoinSize")) {
                this.mMaxJoinSize = db.getAttribute("maxJoinSize");
            }
            if (db.hasAttribute("joinBufferSize")) {
                this.mJoinBufferSize = db.getAttribute("joinBufferSize");
            }
        } else {
            throw new ActivityConfigurationException(this.mName, (Throwable)new XMLMissingElementException("database"));
        }
        NodeList tables = document.getElementsByTagName("table");
        if (tables != null) {
            for (int i = 0; i < tables.getLength(); ++i) {
                Element table = (Element)tables.item(i);
                String name = table.getAttribute(ATTR_NAME);
                this.mTableNames.add(name);
                if (table.hasAttribute(ATTR_ROW_COUNT)) {
                    this.mRowCounts.put(name, table.getAttribute(ATTR_ROW_COUNT));
                }
                if (table.hasAttribute(ATTR_ROW_FORMAT)) {
                    this.mRowFormat.put(name, table.getAttribute(ATTR_ROW_FORMAT));
                }
                if (table.hasAttribute(ATTR_AVG_ROW_SIZE)) {
                    this.mAvgRowLength.put(name, table.getAttribute(ATTR_AVG_ROW_SIZE));
                }
                if (table.hasAttribute(ATTR_DATA_LENGTH)) {
                    this.mDataLength.put(name, table.getAttribute(ATTR_DATA_LENGTH));
                }
                if (!table.hasAttribute(ATTR_INDEX_LENGTH)) continue;
                this.mIndexLength.put(name, table.getAttribute(ATTR_INDEX_LENGTH));
            }
        }
    }

    public Set getTableNames() {
        return this.mTableNames;
    }

    public String getRowCount(String table) {
        return (String)this.mRowCounts.get(table);
    }

    public String getRowFormat(String table) {
        return (String)this.mRowFormat.get(table);
    }

    public String getAverageRowLength(String table) {
        return (String)this.mAvgRowLength.get(table);
    }

    public String getDataLength(String table) {
        return (String)this.mDataLength.get(table);
    }

    public String getIndexLength(String table) {
        return (String)this.mIndexLength.get(table);
    }

    public String getDatabaseName() {
        return this.mDatabase;
    }

    public String getMaxJoinSize() {
        return this.mMaxJoinSize;
    }

    public String getJoinBufferSize() {
        return this.mJoinBufferSize;
    }
}

