/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.relational;

import java.net.UnknownHostException;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityConfiguration;
import uk.org.ogsadai.activity.ActivityConfigurationCreator;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.relational.PhysicalMetaDataToXML;
import uk.org.ogsadai.activity.relational.PhysicalSchemaFileActivityConfiguration;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.NetUtilities;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.exception.DAIUnknownHostException;

public class PhysicalSchemaFileActivity
extends Activity
implements ActivityConfigurationCreator {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private static DAILogger LOG = DAILogger.getLogger((Class)PhysicalSchemaFileActivity.class);
    private PhysicalSchemaFileActivityConfiguration mConfig;
    private String mTableName;
    private Iterator mTables;
    private BlockWriter mOutput;

    public PhysicalSchemaFileActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        super(element);
        Element getTables;
        Element output = (Element)element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "output").item(0);
        String outputName = output.getAttribute("name");
        this.mInternalOutputs = new String[]{outputName};
        NodeList nodelist = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "getTables");
        if (nodelist != null && nodelist.getLength() > 0 && (getTables = (Element)nodelist.item(0)).hasAttribute("name")) {
            this.mTableName = getTables.getAttribute("name");
        }
    }

    public void initialise() throws ActivitySpecificationException, ActivityExecutionException {
        super.initialise();
        try {
            this.mOutput = this.mContext.getOutput(this.mInternalOutputs[0]);
        }
        catch (ActivityStreamNotFoundException e) {
            throw new ActivitySpecificationException(this.getName(), (Throwable)e);
        }
    }

    protected void processFirst() {
        this.mConfig = (PhysicalSchemaFileActivityConfiguration)this.getActivityConfiguration();
        this.mTables = this.mConfig.getTableNames().iterator();
        StringBuffer schema = new StringBuffer();
        try {
            PhysicalMetaDataToXML.writeHeader(schema, NetUtilities.getMachineIPAddress(), this.mConfig.getDatabaseName(), this.mConfig.getMaxJoinSize(), this.mConfig.getJoinBufferSize());
            this.mOutput.put((Object)schema.toString());
        }
        catch (UnknownHostException e) {
            this.setError(new ActivityExecutionException(this.getName(), (Throwable)new DAIUnknownHostException(e)));
        }
    }

    protected void processBlock() {
        StringBuffer schema = new StringBuffer();
        if (this.mTableName != null) {
            if (this.mConfig.getTableNames().contains(this.mTableName)) {
                this.writeTable(this.mTableName, schema);
            }
            PhysicalMetaDataToXML.writeFooter(schema);
            this.mOutput.put((Object)schema.toString());
            this.setCompleted();
            this.mOutput.close();
            this.mOutput = null;
        } else if (this.mTables.hasNext()) {
            String name = (String)this.mTables.next();
            this.writeTable(name, schema);
            this.mOutput.put((Object)schema.toString());
        } else {
            PhysicalMetaDataToXML.writeFooter(schema);
            this.mOutput.put((Object)schema.toString());
            this.setCompleted();
            this.mOutput.close();
            this.mOutput = null;
        }
    }

    protected void cleanUp() {
        if (this.mOutput != null) {
            this.mOutput.close();
        }
    }

    public ActivityConfiguration createActivityConfiguration() {
        return new PhysicalSchemaFileActivityConfiguration(super.getName());
    }

    private void writeTable(String name, StringBuffer schema) {
        String rowCount = this.mConfig.getRowCount(name);
        String rowFormat = this.mConfig.getRowFormat(name);
        String avgRowLength = this.mConfig.getAverageRowLength(name);
        String dataLength = this.mConfig.getDataLength(name);
        String indexLength = this.mConfig.getIndexLength(name);
        PhysicalMetaDataToXML.writeTable(schema, name, rowFormat, rowCount, avgRowLength, dataLength, indexLength);
    }
}

